package net.mehvahdjukaar.every_compat;

import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.AllWoodItem;
import net.mehvahdjukaar.every_compat.misc.ErrorMessageScreen;
import net.mehvahdjukaar.every_compat.misc.WoodTypeCycleItemRenderer;
import net.mehvahdjukaar.moonlight.api.misc.EventCalled;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import java.util.List;
import java.util.function.Supplier;


public class EveryCompatClient {

    public static void init() {
        ClientHelper.addClientSetup(EveryCompatClient::clientSetup);
        EveryCompat.forAllModules(CompatModule::onClientInit);
        ClientHelper.addBlockEntityRenderersRegistration(EveryCompatClient::registerBlockEntityRenderers);
        ClientHelper.addBlockColorsRegistration(EveryCompatClient::registerBlockColors);
        ClientHelper.addItemColorsRegistration(EveryCompatClient::registerItemColors);
        RegHelper.registerDynamicResourceProvider(ClientDynamicResourcesHandler.getInstance());
        ClientHelper.addItemRenderersRegistration(event -> {
            event.register(ECRegistry.ALL_WOODS.get(), new WoodTypeCycleItemRenderer());
        });
    }

    @EventCalled
    public static void onFirstScreen(class_437 screen) {
        var errors = EveryCompat.getModulesThatErrored();
        if (!errors.isEmpty()) {
            class_310.method_1551().method_1507(ErrorMessageScreen.create(screen, errors));
        }
        EveryCompat.canShowErrorScreen = false;
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        EveryCompat.forAllModules(m -> m.registerBlockColors(event));
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        EveryCompat.forAllModules(m -> m.registerItemColors(event));
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        EveryCompat.forAllModules(m -> m.registerBlockEntityRenderers(event));
    }

    public static void clientSetup() {
        EveryCompat.forAllModules(CompatModule::onClientSetup);
    }

    public static void onItemTooltip(class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> components) {
        boolean modTooltip = ECConfigs.MOD_TOOPTIP.get();
        boolean blockTooltip = ECConfigs.BLOCK_TYPE_TOOLTIP.get();

        if (modTooltip || blockTooltip && (tooltipFlag.method_8035() || !ECConfigs.TOOLTIPS_ADVANCED.get())) {
            class_1792 item = stack.method_7909();
            var compatModule = EveryCompat.getModuleOfItem(item);
            if (compatModule != null) {
                if (blockTooltip) {
                    BlockType woodType = WoodTypeRegistry.INSTANCE.getBlockTypeOf(item);
                    if (woodType == null) woodType = LeavesTypeRegistry.INSTANCE.getBlockTypeOf(item);
                    if (woodType != null) {
                        components.add(class_2561.method_43469("tooltip.everycomp.wood_type", woodType.toString()).method_27692(class_124.field_1077));
                    }
                }
                if (modTooltip)
                    components.add(class_2561.method_43469("tooltip.everycomp.mod", compatModule.getModName()).method_27692(class_124.field_1078));
            }
        }
        if (PlatHelper.isDev()) {
            class_2248 blocked = class_2248.method_9503(stack.method_7909());
            // BLOCK TAGS
            if (blocked != class_2246.field_10124) {
                components.add(class_2561.method_43470("BlockTag:").method_27692(class_124.field_1060));
                blocked.method_9564().method_40144().forEach((k) -> components.add(class_2561.method_43470("-" + k.comp_327()).method_27696(class_2583.field_24360.method_36139(0xc8ffc8))));
            }

            // ITEM TAGS
            components.add(class_2561.method_43470("ItemTag:").method_27692(class_124.field_1076));
            stack.method_40133().forEach((k) -> components.add(class_2561.method_43470("-" + k.comp_327()).method_27696(class_2583.field_24360.method_36139(0xffc8ff))));
        }
    }

    public static <B extends class_2248> void registerRenderType(B b, BlockType bt, Object type) {
        if (bt.id.equals(class_2960.method_12829("rats:pirat"))) {
            type = RenderLayer.TRANSLUCENT;
        }
        if (type == null) return;
        if (type instanceof RenderLayer rl) {
            switch (rl) {
                case CUTOUT -> ClientHelper.registerRenderType(b, class_1921.method_23581());
                case CUTOUT_MIPPED -> ClientHelper.registerRenderType(b, class_1921.method_23579());
                case TRANSLUCENT -> ClientHelper.registerRenderType(b, class_1921.method_23583());
                case SOLID -> ClientHelper.registerRenderType(b, class_1921.method_23577());
            }
        } else if (type instanceof Supplier<?> s) {
            class_1921 renderType = ((Supplier<Supplier<class_1921>>) s).get().get();
            ClientHelper.registerRenderType(b, renderType);
        } else if (PlatHelper.isDev()) {
            throw new IllegalArgumentException("Invalid render type: " + type);
        }

    }
}
