package net.mehvahdjukaar.every_compat.misc;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public class UtilityTag {

    /**
     * Get the namespace:WoodType_logs tag from the wood mods or create a new tag if not available
     *
     * @return ResourceLocation
     **/
    public static class_2960 getATagOrCreateANew(String suffixTag, String suffixAlt, BlockType blockType, ResourceSink sink, class_3300 manager) {
        String resLocMOD = blockType.getNamespace() + ":" + blockType.getTypeName();

        // ResourceLocation
        class_2960 RLocLogs = class_2960.method_60654(resLocMOD + "_" + suffixTag); // modId:TYPE_suffix
        class_2960 RLocStems = class_2960.method_60654(resLocMOD + "_" + suffixAlt);
        class_2960 RLocFolders = class_2960.method_60654(blockType.getNamespace() + ":" + suffixTag + "/" + blockType.getTypeName()); // modId:suffix/TYPE
        class_2960 RLocEC = EveryCompat.res(blockType.getAppendableId() + "_" + suffixTag); // everycomp:modId/TYPE_suffix

        if (doTagExistFor(RLocLogs, manager))
            return RLocLogs;
        else if (doTagExistFor(RLocStems, manager))
            return RLocStems;
        else if (doTagExistFor(RLocEC, manager))
            return RLocEC;
        else if (doTagExistFor(RLocFolders, manager))
            return RLocFolders;
        else // if RLocECTags is not available, then it will be generated
            createAndAddDefaultTags(RLocEC, sink, blockType);

        return RLocEC;

    }

    /**
     * The method is to create a custom Tag file with
     * DEFAULT BLOCKS - log, stripped_log, wood, stripped_wood
     *
     * @return true if tag was added successfully
     **/
    public static boolean createAndAddDefaultTags(class_2960 resLoc, ResourceSink sink, BlockType blockType, class_2248... blocks) {
        if (blockType instanceof WoodType woodType)
            return createAndAddCustomTags(resLoc, sink, woodType.log, woodType.getBlockOfThis("stripped_log"), woodType.getBlockOfThis("wood"), woodType.getBlockOfThis("stripped_wood"));
        else
            return createAndAddCustomTags(resLoc, sink, blocks);
    }

    /**
     * Add any blocks to newly created tag
     *
     * @return true if tag was added successfully
     **/
    public static boolean createAndAddCustomTags(class_2960 resLoc, ResourceSink sink, class_2248... blocks) {
        boolean isTagCreated = false;

        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(resLoc);
        // Adding blocks to tag file
        for (class_2248 block : blocks) {
            if (block != null) {
                tagBuilder.addEntry(block);
                isTagCreated = true;
            }
        }
        // Adding to the resources
        if (isTagCreated) {
            sink.addTag(tagBuilder, class_7924.field_41254);
            sink.addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    /**
     * Add any items to newly created tag
     *
     * @return true if tag was added successfully
     **/
    public static boolean createAndAddCustomTags(class_2960 resLoc, ResourceSink sink, class_1792... items) {
        boolean isTagCreated = false;

        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(resLoc);
        // Adding blocks to tag file
        for (class_1792 item : items) {
            if (item != null) {
                tagBuilder.addEntry(item);
                isTagCreated = true;
            }
        }
        // Adding to the resources
        if (isTagCreated) {
            sink.addTag(tagBuilder, class_7924.field_41197);
        }
        return isTagCreated;
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId, String tag,
            boolean includeBlock, boolean includeItem, ResourceSink pack
    ) {
        addTagToAllBlocks(blocks, nameStone, modId,
                class_6862.method_40092(class_7924.field_41254, class_2960.method_60654(tag)),
                includeBlock, includeItem, pack);
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId, class_6862<class_2248> tag,
            boolean includeBlock, boolean includeItem, ResourceSink pack
    ) {
        addTagToAllBlocks(blocks, nameStone, modId,
                tag, includeBlock, includeItem, pack, null);
    }

    /// The tag will be added if the mod is loaded
    public static <T extends BlockType, B extends class_2248> void addTagToAllBlocks(
            Map<T, B> blocks, String nameStone, String modId,
            class_6862<class_2248> tag, boolean includeBlock, boolean includeItem, ResourceSink pack,
            @Nullable String regexBlockId
    ) {
        if (PlatHelper.isModLoaded(modId)) {
            boolean isTagCreated = false;
            SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tag);
            for (Map.Entry<T, B> entry : blocks.entrySet()) {
                T stoneType = entry.getKey();
                B block = entry.getValue();

                String blockPath = Utils.getID(block).method_12832();
                String blockId = blockPath.substring(blockPath.lastIndexOf("/") + 1);

                if (stoneType.getTypeName().equals(nameStone) &&
                        (regexBlockId == null || blockId.matches(regexBlockId))) {
                    tagBuilder.addEntry(block);
                    isTagCreated = true;
                }
            }
            if (isTagCreated) {
                if (includeBlock) pack.addTag(tagBuilder, class_7924.field_41254);
                if (includeItem) pack.addTag(tagBuilder, class_7924.field_41197);
            }
        }
    }

    /**
     * Get the id tag from the mods
     *
     * @return Pair of ResourceLocation, Boolean
     **/
    public static Pair<class_2960, Boolean> getATagId(String idTag, String idAlt, class_3300 manager) {
        // ResourceLocation
        class_2960 RLocId = class_2960.method_60654(idTag); // forge:suffix/EXTRA_TYPE or c:TYPE_ingot
        class_2960 RLocIdAlt = class_2960.method_60654(idAlt); // forge:suffix/EXTRATYPE or c:TYPEingot

        if (doTagExistFor(RLocId, manager))
            return Pair.of(RLocId, true);
        else if (doTagExistFor(RLocIdAlt, manager))
            return Pair.of(RLocIdAlt, true);

        return Pair.of(null, false);
    }

    /// Checking if a tag exist for a block or an item
    private static boolean doTagExistFor(class_2960 resLoc, class_3300 manager) {
        boolean blockTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("blocks/"))).isPresent();
        boolean itemTag = manager.method_14486(ResType.TAGS.getPath(resLoc.method_45138("items/"))).isPresent();
        return blockTag || itemTag;
    }

    // Common tags

    @SuppressWarnings("SameParameterValue")
    /// @return c:tagPath for FABRIC or neoforge:tagPath for NEOFORGE
    private static class_2960 platformTag(String tagPath) {
        return platformTag(tagPath, tagPath);
    }

    public static class_2960 platformTag(String fabric, String neoforge) {
        return PlatHelper.getPlatform().isFabric() ? fabricTag(fabric) : neoforgeTag(neoforge);
    }

    /// @return c:tagPath
    public static class_2960 fabricTag(String tagPath) {
        return class_2960.method_60655("c", tagPath);
    }

    /// @return neoforge:tagPath
    public static class_2960 neoforgeTag(String tagPath) {
        return class_2960.method_60655("neoforge", tagPath);
    }



    public static final class_2960 SILICA_TAG = platformTag("silica_glass", "silica");
    public static final class_2960 GLASS_TAG = platformTag("glass_blocks", "glass");
    public static final class_2960 GLASS_PANE_TAG = platformTag("glass_panes");

}
