package net.mehvahdjukaar.every_compat.modules.decorative_blocks;

import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_4970;
import net.minecraft.class_7924;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.*;

//NAME: Decorative Blocks Reborn
//SUPPORT: v6.0.1+
public class DecorativeBlocksModule extends SimpleModule {

    public final Map<WoodType, net.minecraft.class_4719> wtConversion = new HashMap<>();
    public final SimpleEntrySet<WoodType, class_2248> beams;
    public final SimpleEntrySet<WoodType, class_2248> palisades;
    public final SimpleEntrySet<WoodType, class_2248> supports;
    public final SimpleEntrySet<WoodType, class_2248> seats;

    public DecorativeBlocksModule(String modId) {
        super(modId, "db", EveryCompat.MOD_ID);
        class_2960 tab = modRes("general");

        beams = SimpleEntrySet.builder(WoodType.class, "beam",
                        getModBlock("oak_beam"), () -> VanillaWoodTypes.OAK,
                        w -> new BeamBlock(wtConversion.get(w),
                                copyStandardProperties(w, 1.2F, 0)
                        )
                )
                .requiresChildren(STRIPPED_LOG) //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_35571, class_7924.field_41254)
                .addTag(class_3481.field_15475, class_7924.field_41254)
                .addTag(class_3481.field_23210, class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .addTag(modRes("beams_that_burn"), class_7924.field_41254)
                .addTag(class_3489.field_15539, class_7924.field_41197)
                .addTag(class_3489.field_23212, class_7924.field_41197)
                .addTag(modRes("beams"), class_7924.field_41197)
                .addTag(modRes("beams_that_burn"), class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .addTexture(modRes("block/oak_beam_end"), PaletteStrategies.SIGN_LIKE)
                .addTexture(modRes("block/oak_beam_side"), PaletteStrategies.SIGN_LIKE)
                .build();
        this.addEntry(beams);


        palisades = SimpleEntrySet.builder(WoodType.class, "palisade",
                        getModBlock("oak_palisade"), () -> VanillaWoodTypes.OAK,
                        w -> new PalisadeBlock(wtConversion.get(w),
                                copyStandardProperties(w, 2.0F, 4.0F)
                        )
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .addTag(modRes("palisades"), class_7924.field_41254)
                .addTag(modRes("palisades_that_burn"), class_7924.field_41254)
                .addTag(modRes("palisades"), class_7924.field_41197)
                .addTag(modRes("palisades_that_burn"), class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .addTexture(modRes("block/oak_palisade_end"), PaletteStrategies.SIGN_LIKE)
                .addTexture(modRes("block/oak_palisade_side"), PaletteStrategies.SIGN_LIKE)
                .build();
        this.addEntry(palisades);


        supports = SimpleEntrySet.builder(WoodType.class, "support",
                        getModBlock("oak_support"), () -> VanillaWoodTypes.OAK,
                        w -> new SupportBlock(wtConversion.get(w),
                                copyStandardProperties(w, 1.2F, 0)
                        )
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41254)
                .addTag(modRes("supports_that_burn"), class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41197)
                .addTag(modRes("supports_that_burn"), class_7924.field_41197)
                .addCustomItem((w, b, p) -> new SupportItem(b, p))
                .defaultRecipe()
                .setTabKey(tab)
                .addTexture(modRes("block/oak_support_end"), PaletteStrategies.SIGN_LIKE)
                .addTexture(modRes("block/oak_support_side"), PaletteStrategies.SIGN_LIKE)
                .build();
        this.addEntry(supports);


        seats = SimpleEntrySet.builder(WoodType.class, "seat",
                        getModBlock("oak_seat"), () -> VanillaWoodTypes.OAK,
                        w -> new SeatBlock(wtConversion.get(w),
                                copyStandardProperties(w, 1.2F, 0)
                        )
                )
                .requiresChildren(FENCE, SLAB) //REASON: recipes
                .addTexture(modRes("block/oak_seat"), PaletteStrategies.SIGN_LIKE)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("seats_that_burn"), class_7924.field_41254)
                .addTag(modRes("seats"), class_7924.field_41254)
                .addTag(modRes("seats"), class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .addCustomItem((w, b, p) -> new SeatItem(b, p))
                .build();
        this.addEntry(seats);

    }

    public class_4970.class_2251 copyStandardProperties(WoodType woodType, float destroyTimeOrStrength, float explosiveResistence) {
        if (explosiveResistence != 0)
            return class_4970.class_2251.method_9637().method_31710(woodType.getColor()).method_9626(woodType.getSound())
                    .method_9629(destroyTimeOrStrength, explosiveResistence)
                    .method_50013();
        else
            return class_4970.class_2251.method_9637().method_31710(woodType.getColor()).method_9626(woodType.getSound())
                    .method_9632(destroyTimeOrStrength)
                    .method_50013();
    }

    @Override
    public <T extends BlockType> void registerBlocks(Class<T> typeClass,
                                                     Registrator<class_2248> registry, Collection<T> types) {
        if (typeClass == WoodType.class) {
            types.forEach(w -> wtConversion.put((WoodType) w,
                    new net.minecraft.class_4719(w.getTypeName(), ((WoodType) w).toVanillaOrOak().comp_1300())));
        }
        super.registerBlocks(typeClass, registry, types);
    }

}