package net.mehvahdjukaar.every_compat.modules.fabric.beautify_decorate;

import io.github.suel_ki.beautify.common.block.Blinds;
import io.github.suel_ki.beautify.common.block.PictureFrame;
import io.github.suel_ki.beautify.common.block.Trellis;
import io.github.suel_ki.beautify.core.init.BlockInit;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7924;

import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.SLAB;

//SUPPORT: v1.2.0+
public class BeautifyRefabricatedModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, Trellis> tellis;
    public final SimpleEntrySet<WoodType, Blinds> blinds;
    public final SimpleEntrySet<WoodType, PictureFrame> picture_frames;

    public BeautifyRefabricatedModule(String modId) {
        super(modId, "bd");
        class_2960 tab = modRes("group");

        tellis = SimpleEntrySet.builder(WoodType.class, "trellis",
                        () -> BlockInit.OAK_TRELLIS, () -> VanillaWoodTypes.OAK,
                        w -> new Trellis(class_4970.class_2251.method_9637()
                                .method_31710(class_3620.field_15996)
                                .method_9629(0.3F, 0.3F)
                                .method_9626(class_2498.field_11542)
                                .method_22488()
                        )
                )
                //TEXTURES: loglogs
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_22414, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                //REASON: take a look at their //TEXTURES, you'll see why.
                .excludeBlockTypes("terrestria:(sakura|yucca_palm)|betternether:(nether_mushroom|nether_reed)")
                .excludeBlockTypes("betternether:(nether_mushroom|nether_reed)")
                .build();
        this.addEntry(tellis);

        blinds = SimpleEntrySet.builder(WoodType.class, "blinds",
                        () -> BlockInit.OAK_BLINDS, () -> VanillaWoodTypes.OAK,
                        w -> new Blinds(Utils.copyPropertySafe(w.planks)
                                .method_22488().method_9629(0.4F, 0.4F)
                                .method_9626(class_2498.field_11547)
                        )
                )
                //TEXTURES: planks
                .requiresChildren(SLAB) //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(blinds);

        picture_frames = SimpleEntrySet.builder(WoodType.class, "picture_frame",
                        () -> BlockInit.OAK_PICTURE_FRAME, () -> VanillaWoodTypes.OAK,
                        w -> new PictureFrame(Utils.copyPropertySafe(w.planks)
                                .method_22488().method_9629(0.1F, 0.1F)
                                .method_9626(class_2498.field_11547).method_22488()
                                .method_50012(class_3619.field_15971)
                        )
                )
                .requiresChildren(SLAB) //REASON: recipes
                .addTexture(modRes("block/oak_frame_texture"))
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(picture_frames);


    }
}