/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class TextureGenHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BlockType> void generateDefault(ResourceSink sink, class_3300 manager, String modId, Set<TextureInfo> textureInfos, T baseType, boolean mergePalette, Map<T, ?> entries) throws Exception {
        ArrayList<TextureImage> imagesToClose = new ArrayList<TextureImage>();
        class_1935 mainChild = baseType.mainChild();
        if (!(mainChild instanceof class_2248)) {
            return;
        }
        class_2248 mainChildBlock = (class_2248)mainChild;
        try (TextureImage oakPlanksTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)mainChildBlock));){
            Palette oakPlanksPalette = Palette.fromImage((TextureImage)oakPlanksTexture);
            HashMap<class_2960, Respriter> respriters = new HashMap<class_2960, Respriter>();
            HashMap<class_2960, TextureImage> partialRespriters = new HashMap<class_2960, TextureImage>();
            Palette globalPalette = Palette.empty();
            ArrayListMultimap infoPerTextures = ArrayListMultimap.create();
            for (TextureInfo textureInfo : textureInfos) {
                class_2960 textureId = textureInfo.texture();
                try {
                    class_2960 maskId = textureInfo.mask();
                    TextureImage main = TextureImage.open((class_3300)manager, (class_2960)textureId);
                    infoPerTextures.put((Object)textureId, (Object)textureInfo);
                    if (textureInfo.copyTexture()) {
                        respriters.put(textureId, Respriter.ofPalette((TextureImage)main, (Palette)Palette.ofColors(Set.of(new RGBColor(0)))));
                        continue;
                    }
                    imagesToClose.add(main);
                    if (maskId != null) {
                        if (textureInfo.autoMask()) {
                            if (mergePalette) {
                                globalPalette.addAll((Collection)oakPlanksPalette);
                                partialRespriters.put(textureId, main);
                                continue;
                            }
                            respriters.put(textureId, Respriter.ofPalette((TextureImage)main, (Palette)oakPlanksPalette));
                            continue;
                        }
                        TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)maskId);
                        if (mergePalette) {
                            globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, (TextureImage)mask, (float)0.0f));
                            partialRespriters.put(textureId, main);
                            continue;
                        }
                        respriters.put(textureId, Respriter.masked((TextureImage)main, (TextureImage)mask));
                        continue;
                    }
                    if (mergePalette) {
                        globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, null, (float)0.0f));
                        partialRespriters.put(textureId, main);
                        continue;
                    }
                    respriters.put(textureId, Respriter.of((TextureImage)main));
                }
                catch (UnsupportedOperationException e) {
                    EveryCompat.LOGGER.error("Could not generate textures for {}", (Object)textureInfo, (Object)e);
                }
                catch (Exception e) {
                    if (PlatHelper.isDev()) {
                        throw new RuntimeException(e);
                    }
                    EveryCompat.LOGGER.error("Failed to read block texture at {}", (Object)textureInfo, (Object)e);
                }
            }
            for (Map.Entry entry : partialRespriters.entrySet()) {
                respriters.put((class_2960)entry.getKey(), Respriter.ofPalette((TextureImage)((TextureImage)entry.getValue()), (Palette)globalPalette));
            }
            for (Map.Entry entry : entries.entrySet()) {
                Object block = entry.getValue();
                BlockType blockType = (BlockType)entry.getKey();
                class_2960 blockId = Utils.getID(block);
                for (Map.Entry respriterSet : respriters.entrySet()) {
                    class_2960 oldTextureId = (class_2960)respriterSet.getKey();
                    String oldPath = oldTextureId.method_12832();
                    String newPath = oldPath.startsWith("entity/") && modId.equals("boatload") ? BlockTypeResTransformer.replaceFullGenericType((String)oldPath, (BlockType)blockType, (class_2960)blockId, (String)baseType.getTypeName(), null, (int)2) : BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)blockType, (class_2960)blockId, (String)baseType.getTypeName());
                    for (TextureInfo info : infoPerTextures.get((Object)oldTextureId)) {
                        class_2960 newId;
                        PaletteStrategy.PaletteAndAnimation pal = Objects.requireNonNull(info).paletteStrategy().getPaletteAndAnimation(blockType, manager);
                        McMetaFile targetAnimation = pal.animation();
                        List<Palette> targetPalette = pal.palette();
                        int oldSize = targetPalette.getFirst().size();
                        if (oldSize != targetPalette.getFirst().size()) {
                            throw new RuntimeException("This should not happen. A palette of size 0 was found");
                        }
                        if (info.customTexturePath() != null) {
                            oldPath = info.customTexturePath();
                            transformedPath = BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)blockType, (class_2960)blockId, (String)baseType.getTypeName());
                            newId = blockId.method_45136(transformedPath);
                        } else if (Objects.nonNull(info.replacePath())) {
                            transformedPath = newPath.replace((CharSequence)info.replacePath().getFirst(), (CharSequence)info.replacePath().getSecond());
                            newId = blockId.method_45136(transformedPath);
                        } else {
                            newId = info.keepNamespace() ? oldTextureId.method_45136(newPath) : class_2960.method_60655((String)blockId.method_12836(), (String)newPath);
                        }
                        if (newId.method_12832().isEmpty()) {
                            EveryCompat.LOGGER.error("The path of new texture is empty for: {}", (Object)info.texture());
                            continue;
                        }
                        class_2960 finalNewId = newId;
                        sink.addTextureIfNotPresent(manager, newId, () -> {
                            Respriter respriter = (Respriter)respriterSet.getValue();
                            TextureImage img = respriter.recolorWithAnimation(targetPalette, targetAnimation);
                            TextureGenHelper.postProcessSpecialTexture(blockType, finalNewId, manager, img, info);
                            return img;
                        });
                    }
                }
            }
        }
        finally {
            imagesToClose.forEach(TextureImage::close);
        }
    }

    private static <T extends BlockType> TextureImage postProcessSpecialTexture(T blockType, class_2960 newId, class_3300 manager, TextureImage texture, TextureInfo textureInfo) {
        if (blockType.getClass() == WoodType.class) {
            CompatSpritesHelper.maybePostProcessWoodTexture((WoodType)blockType, newId, manager, texture, textureInfo);
        }
        return texture;
    }
}

