/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.regions_unexplored;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.block.plant.tall.ShrubBlock;

public class RegionsUnexploredModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> branchs;
    public final SimpleEntrySet<LeavesType, Block> shrubs;

    public RegionsUnexploredModule(String modId) {
        super(modId, "ru");
        ResourceLocation tab = this.modRes("ru_main");
        this.branchs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "branch", this.getModBlock("oak_branch"), () -> WoodTypeRegistry.OAK_TYPE, w -> new BranchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)RuBlocks.ACACIA_BRANCH.get())), "branch")).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("branches_can_survive_on"), Registries.f_256747_)).addTag(this.modRes("branches"), Registries.f_256747_)).addTag(this.modRes("branches"), Registries.f_256913_)).setTabKey(tab)).addRecipe(this.modRes("oak_branch_from_oak_log"))).build();
        this.addEntry(this.branchs);
        this.shrubs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(LeavesType.class, "shrub", this.getModBlock("dark_oak_shrub"), () -> LeavesTypeRegistry.getValue((String)"dark_oak"), l -> new ShrubBlock(Utils.copyPropertySafe((Block)l.leaves).m_278166_(PushReaction.DESTROY).m_278183_().m_60910_().m_60966_().m_60918_(SoundType.f_154666_).m_222979_(BlockBehaviour.OffsetType.XZ))).addCondition(l -> {
            boolean log = l.getWoodType() != null;
            boolean sapling = l.getItemOfThis("sapling") != null;
            return log && sapling;
        })).addTag(BlockTags.f_144280_, Registries.f_256747_)).addTag(this.modRes("shrubs"), Registries.f_256747_)).addTag(this.modRes("shrub_can_survive_on"), Registries.f_256747_)).addTag(this.modRes("shrubs"), Registries.f_256913_)).setTabKey(tab)).addRecipe(this.modRes("dark_oak_sapling_from_dark_oak_shrub"))).addRecipe(this.modRes("dark_oak_shrub"))).copyParentDrop().copyParentTint()).build();
        this.addEntry(this.shrubs);
    }

    @Override
    public void onModSetup() {
        this.branchs.blocks.forEach((woodType, block) -> ComposterBlock.f_51914_.put(block, 0.3f));
    }

    @Override
    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.getTypes()) {
                if (woodType.isVanilla() || woodType.getNamespace().equals("regions_unexplored")) continue;
                TagUtility.createAndAddCustomTags(new ResourceLocation("planks"), sink, woodType.planks);
                TagUtility.createAndAddCustomTags(new ResourceLocation("forge:planks"), sink, woodType.planks);
            }
        });
    }

    @Override
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            try (TextureImage branch_side = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("item/oak_branch_side"));
                 TextureImage branch_top = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("item/oak_branch_top"));
                 TextureImage branch_block = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/oak_branch"));){
                this.branchs.blocks.forEach((wood, block) -> {
                    try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        ResourceLocation resLocITEM = EveryCompat.res("item/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");
                        ResourceLocation resLocBLOCK = EveryCompat.res("block/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");
                        Respriter respriterSIDE = Respriter.of((TextureImage)branch_side);
                        Respriter respriterTOP = Respriter.of((TextureImage)branch_top);
                        Respriter respriterBlock = Respriter.of((TextureImage)branch_block);
                        List list_logSide = Palette.fromAnimatedImage((TextureImage)logSide_texture);
                        List list_logTop = Palette.fromAnimatedImage((TextureImage)logTop_texture);
                        TextureImage recoloredITEM = respriterSIDE.recolor(list_logSide);
                        TextureImage recoloredTOP = respriterTOP.recolor(list_logTop);
                        recoloredITEM.applyOverlay(new TextureImage[]{recoloredTOP});
                        TextureImage recoloredBLOCK = respriterBlock.recolor(list_logSide);
                        sink.addAndCloseTexture(resLocBLOCK, recoloredBLOCK);
                        sink.addAndCloseTexture(resLocITEM, recoloredITEM);
                    }
                    catch (IOException e) {
                        EveryCompat.LOGGER.error("Failed to get Log Texture for {} : {}", block, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to get Branch Item Texture for ", (Throwable)e);
            }
            try (TextureImage shrubTop = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/dark_oak_shrub_top"));
                 TextureImage shrubBottom = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/dark_oak_shrub_bottom"));
                 TextureImage shrubTopMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/ru/mask_shrub_top"));
                 TextureImage shrubMiddleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/ru/mask_shrub_middle"));){
                this.shrubs.blocks.forEach((leavesType, block) -> {
                    String shrubPath = leavesType.createPathWith(this.shortenedId(), "shrub");
                    try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)leavesType.getWoodType().log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                         TextureImage leavesTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)leavesType.leaves, SpriteHelper.LOOKS_LIKE_LEAF_TEXTURE));){
                        Respriter respriterBottom = Respriter.of((TextureImage)shrubBottom);
                        Respriter respriterTop = Respriter.masked((TextureImage)shrubTop, (TextureImage)shrubMiddleMask);
                        List list_logSide = Palette.fromAnimatedImage((TextureImage)logTexture);
                        List list_leaves = Palette.fromAnimatedImage((TextureImage)leavesTexture);
                        TextureImage finishedShrubBottom = respriterBottom.recolor(list_logSide);
                        TextureImage recoloredShrubTop = respriterTop.recolor(list_leaves);
                        Respriter respriterMiddle = Respriter.masked((TextureImage)recoloredShrubTop, (TextureImage)shrubTopMask);
                        TextureImage finishedShrub = respriterMiddle.recolor(list_logSide);
                        String resLoc = "block/" + shrubPath;
                        sink.addAndCloseTexture(EveryCompat.res(resLoc + "_bottom"), finishedShrubBottom);
                        sink.addAndCloseTexture(EveryCompat.res(resLoc + "_top"), finishedShrub);
                    }
                    catch (IOException e) {
                        EveryCompat.LOGGER.error("Failed to get texture for {} : {}", (Object)block.toString(), (Object)e.getMessage());
                    }
                });
            }
            catch (IOException e) {
                EveryCompat.LOGGER.error("Failed to open textures for: {}", (Object)e.getMessage());
            }
        });
    }
}

