package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy.PaletteAndAnimation;
import net.mehvahdjukaar.every_compat.configs.ModEntriesConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ColoringUtils;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.every_compat.misc.TextureGenHelper;
import net.mehvahdjukaar.every_compat.misc.UtilityTag;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static net.mehvahdjukaar.every_compat.misc.UtilityTag.addTagToAllBlocks;

//contrary to popular belief this class is indeed not simple. Its usage however is
@SuppressWarnings({"unused"})
public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends class_2248, I extends class_1792> implements EntrySet<T> {

    public static int totalChildren = 0;

    protected static final class_2960 NO_TAB_MARKER = new class_2960("none");

    public final Map<T, B> blocks = new HashMap<>();
    public final Map<T, I> items = new HashMap<>();

    protected final Class<T> type;

    protected final Pattern nameScheme;

    protected final Supplier<T> baseType;

    public final String typeName;

    public final String postfix;
    @Nullable
    public final String prefix;
    protected final boolean mergePalette;

    protected final Supplier<class_5321<class_1761>> tab;
    protected final TabAddMode tabMode;
    protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap<>();
    protected final Set<Supplier<class_2960>> recipeLocations = new HashSet<>();
    protected final Set<TextureInfo> textures = new HashSet<>();
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraModelTransform;

    protected final Predicate<T> condition;

    protected final boolean copyTint;

    protected AbstractSimpleEntrySet(Class<T> type,
                                     String name, @Nullable String prefix,
                                     Supplier<T> baseType,
                                     Supplier<class_5321<class_1761>> tab,
                                     TabAddMode tabMode,
                                     BiFunction<T, class_3300, PaletteStrategy.PaletteAndAnimation> paletteSupplier,
                                     @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform,
                                     boolean mergePalette, boolean copyTint,
                                     Predicate<T> condition) {
        this.typeName = (prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name;
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.tabMode = tabMode;
        this.baseType = baseType;
        this.type = type;
        this.copyTint = copyTint;

        this.extraModelTransform = extraTransform;
        this.mergePalette = mergePalette;

        if (this.prefix != null) {
            if (postfix.isEmpty()) {
                nameScheme = Pattern.compile("^" + prefix + "_(.+?)$");
            } else {
                nameScheme = Pattern.compile("^" + prefix + "_(.+?)_" + postfix + "$");
            }
        } else {
            nameScheme = Pattern.compile("^(.+?)_" + postfix + "$");
        }
        this.condition = condition;

        if (tab == null && PlatHelper.isDev()) {
            throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
        }
    }

    @Override
    public int getBlockCount() {
        return this.blocks.size();
    }

    @Override
    public String getName() {
        return typeName;
    }

    @Override
    public @Nullable class_1792 getItemOf(T type) {
        var i = items.get(type);
        if (ModEntriesConfigs.isEntryEnabled(type, i)) return i;
        return null;
    }

    public Class<T> getTypeClass() {
        return type;
    }

    public T getBaseType() {
        return baseType.get();
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        String wood = parseWoodType(oldName);
        if (wood != null) {
            var w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new class_2960(woodFrom, wood));
            if (w != null) {
                return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
            }
        }
        return null;
    }

    //gets the wood type of the given name if it is in this entry set name format
    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        if (copyTint) ColoringUtils.copyBlockTint(event, blocks);
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        if (copyTint) {
            ColoringUtils.copyBlockTint(event, blocks);
            ColoringUtils.copyItemTint(event, items);
        }
    }

    @Override
    public void registerItemsToExistingTabs(SimpleModule module, RegHelper.ItemToTabEvent event) {
        if (tab == null) {
            if (PlatHelper.isDev()) {
                throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
            }
            return;
        }
        class_5321<class_1761> tab = this.tab.get();
        if (tab.method_29177().equals(NO_TAB_MARKER)) {
            return;
        }
        //verify tab
        if (!class_7923.field_44687.method_35842(tab)) {
            throw new UnsupportedOperationException("Creative tab " + tab + " not registered found in the registries. " +
                    "This means that the target mod must have changed its name. " +
                    "You can either downgrade the mod" + tab.method_29177().method_12836() + " or wait for an Every Compat update");
        }
        if (tabMode == TabAddMode.AFTER_ALL) {
            event.add(tab, items.values().toArray(new class_1792[0]));
        } else if (tabMode == TabAddMode.AFTER_SAME_WOOD) {
            var reg = BlockSetAPI.getBlockSet(type);
            for (var e : items.entrySet()) {
                var item = e.getValue();
                var wood = e.getKey();
                //adds after first wooden block it finds. quite bad tbh
                event.addAfter(tab, s -> reg.getBlockTypeOf(s.method_7909()) == wood, item);
            }
        } else if (tabMode == TabAddMode.AFTER_SAME_TYPE) {
            var reg = BlockSetAPI.getBlockSet(type);
            String childKey = getChildKey(module);
            Class<T> typeClass = this.getTypeClass();
            for (var e : items.entrySet()) {
                var item = e.getValue();
                event.addAfter(tab, s -> {
                    T type = reg.getBlockTypeOf(s.method_7909());
                    if (type == null) return false;
                    return type.getClass() == typeClass
                            && Objects.equals(type.getChildKey(s.method_7909()), childKey);
                }, item);
            }
        }
    }

    @Override
    public void generateTags(SimpleModule module, class_3300 manager, ResourceSink sink) {
        if (!tags.isEmpty()) {
            for (var tb : tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of(tb.getKey());
                for (var b : getDefaultEntries().entrySet()) {
                    if (ModEntriesConfigs.isEntryEnabled(b.getKey(), b.getValue())) {
                        builder.addEntry(b.getValue());
                    }
                }
                for (var t : tb.getValue()) {
                    sink.addTag(builder, t);
                }
            }
        }

        // Adding tag to a specific WoodType of all generated blocks
        /// Sully's Mod
        addTagToAllBlocks(blocks, "petrified", "sullysmod",
                class_3481.field_33715.comp_327().toString(), true, false, sink);

        /// Soulful Nether
        String regEx = "\\w+_(log|planks|beehive|boards|sanded_wood|beam|parquet|trim|bookshelf|window|drawer|table|bookshelf|shelf|table|support|cabinet|board_stairs|board_slab|boards)";
        addTagToAllBlocks(blocks, "fright", "soulfulnether",
                class_3481.field_23119.comp_327().toString(), true, false, sink, regEx);

        /// Regions Unexplored
        addTagToAllBlocks(blocks, "(brimwood|cobalt|dead|yellow_bioshroom)",
                "regions_unexplored", class_3481.field_23209.comp_327().toString(),
                true, false, sink);
        addTagToAllBlocks(blocks, "(brimwood|cobalt|dead|yellow_bioshroom)",
                "regions_unexplored", "minecraft:non_flammable_wood",
                false, true, sink);

        /// Botania
        if (PlatHelper.isModLoaded("botania")) {
            String glassRegEx = "\\w+_(?:window|glass)";
            String glassPaneRegEx = "\\w+_(?:window|glass)_pane";
            addTagToAllBlocks(blocks, ".*", "", UtilityTag.GLASS_TAG.toString(),
                    true, true, sink, glassRegEx);
            addTagToAllBlocks(blocks, ".*", "", UtilityTag.GLASS_PANE_TAG.toString(),
                    true, true, sink, glassPaneRegEx);
        }

    }

    public Map<T, ?> getDefaultEntries() {
        return blocks;
    }

    @Override
    public void generateRecipes(SimpleModule module, class_3300 manager, ResourceSink sink) {
        int i = 0;
        for (var r : this.recipeLocations) {
            var res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, sink, items, res, baseType.get(), i++);
            } catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", res, e);
            }
        }
    }

    @Override
    public void generateTextures(SimpleModule module, class_3300 manager, ResourceSink sink) {
        if (textures.isEmpty()) return;
        try {
            TextureGenHelper.generateDefault(sink, manager, module.modId, textures, getBaseType(),
                    mergePalette, this.getDefaultEntries());
        } catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {}: {}",
                    module == null ? "dummy" : module.modRes(this.getName()), e);
        }
    }


    @SuppressWarnings("unchecked")
    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends class_2248, I extends class_1792> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<class_5321<class_1761>> tab = null;
        protected TabAddMode tabMode = TabAddMode.AFTER_SAME_TYPE;
        protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap<>();
        protected final Set<Supplier<class_2960>> recipes = new HashSet<>();
        protected final Set<TextureInfo> textures = new HashSet<>();
        protected boolean useMergedPalette;
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;
        protected boolean copyTint = false;

        @Deprecated(forRemoval = true)
        protected BiFunction<T, class_3300, PaletteStrategy.PaletteAndAnimation> palette = null;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        //adds an extra model transform
        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL) this;
        }

        //exclusive with addCondition
        public BL requiresChildren(String... childKeys) {
            this.addCondition(w -> {
                for (var c : childKeys) {
                    if (w.getChild(c) == null) return false;
                }
                return true;
            });
            return (BL) this;
        }

        //exclusive with addCondition
        public BL requiresFromMap(Map<T, ?> entrySet) {
            this.addCondition(blockType -> !Objects.isNull(entrySet.get(blockType)));
            return (BL) this;
        }

        // Exclude Leaves | Wood | Stone - exclusive with addCondition
        public BL excludeBlockTypes(String regEx) {
            this.addCondition(blockType -> !blockType.getId().toString().matches(regEx));
            return (BL) this;
        }

        // Exclude Leaves | Wood | Stone - exclusive with addCondition
        public BL excludeBlockTypes(String modId, String... typeIds) {
            StringBuilder regexBuilder = new StringBuilder();

            // create "biomesoplenty:(fir)" or "biomesoplenty:(fir|dead|...)
            regexBuilder.append(modId).append(":(");
            for (int i = 0; i < typeIds.length; i++) {
                regexBuilder.append(typeIds[i]);
                if (i != (typeIds.length - 1)) regexBuilder.append("|"); // Don't append "|" to the last word's
            }
            regexBuilder.append(")");

            this.addCondition(blockType -> !blockType.getId().toString().matches(regexBuilder.toString()));
            return (BL) this;
        }

        public BL addCondition(Predicate<T> newCondition) {
            this.condition = this.condition == null ? newCondition :
                    this.condition.and(newCondition);
            return (BL) this;
        }

        public BL copyParentTint() {
            this.copyTint = true;
            return (BL) this;
        }

        public BL setTabMode(TabAddMode mode) {
            this.tabMode = mode;
            return (BL) this;
        }

        public BL noTab() {
            return setTabKey(NO_TAB_MARKER);
        }

        public BL setTabKey(class_2960 res) {
            var key = class_5321.method_29179(class_7924.field_44688, res);
            this.tab = () -> key;
            return (BL) this;
        }

        @Deprecated(forRemoval = true)
        public BL setTabKey(Supplier<class_5321<class_1761>> tab) {
            this.tab = tab;
            return (BL) this;
        }

        public BL setTabKey(class_5321<class_1761> key) {
            this.tab = () -> key;
            return (BL) this;
        }

        @Deprecated(forRemoval = true)
        @SuppressWarnings("OptionalGetWithoutIsPresent")
        public BL setTab(Supplier<class_1761> tab) {
            this.tab = Suppliers.memoize(() -> class_7923.field_44687.method_29113(tab.get()).get());
            return (BL) this;
        }

        public BL addTag(class_2960 tag, class_5321<?> registries) {
            return this.addTag(tag, new class_5321[]{registries});
        }

        public BL addTag(class_2960 location, class_5321<?>... registries) {
            var s = this.tags.computeIfAbsent(location, b -> new HashSet<>());
            s.addAll(List.of(registries));
            return (BL) this;
        }

        public BL addTag(class_6862<?> tag, class_5321<?> registries) {
            return this.addTag(tag, new class_5321[]{registries});
        }


        public BL addTag(class_6862<?> tag, class_5321<?>... registries) {
            addTag(tag.comp_327(), registries);
            return (BL) this;
        }

        public BL addRecipe(class_2960 resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL) this;
        }

        public BL addTexture(TextureInfo.Builder textureLoc) {
            if (PlatHelper.getPhysicalSide().isClient()) {
                TextureInfo info = textureLoc.build();
                this.textures.add(info);
                if (info.keepNamespace()) {
                    //hack so we assure namespace has been added since it could be NOT Ec one
                    ClientDynamicResourcesHandler.getInstance().dynamicPack
                            .addNamespaces(info.texture().method_12836());
                }
            }
            return (BL) this;
        }

        public BL addTexture(class_2960 resourceLocation) {
            return addTexture(TextureInfo.of(resourceLocation));
        }

        public BL addTexture(class_2960 resourceLocation, PaletteStrategy palette) {
            return addTexture(TextureInfo.of(resourceLocation)
                    .palette(palette));
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation) {
            return addTexture(TextureInfo.of(textureLocation)
                    .mask(maskLocation));
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation, PaletteStrategy palette) {
            return addTexture(TextureInfo.of(textureLocation)
                    .mask(maskLocation)
                    .palette(palette));
        }

        /// Custom Texture Path is for placing the texture in the correct ResourceLocation
        public BL addTextureC(class_2960 textureLocation, String customTexturePath) {
            return addTexture(TextureInfo.of(textureLocation, customTexturePath));
        }

        // adds a texture with automatic masking. Experimental
        public BL addTextureAutoM(class_2960 textureLocation) {
            return addTexture(TextureInfo.of(textureLocation)
                    .autoMask());
        }

        public BL useMergedPalette() {
            this.useMergedPalette = true;
            return (BL) this;
        }


        //by default, they all use planks palette
        /// @deprecated Use {@link PaletteStrategies} to create a new strategies instead of setPalette()
        @Deprecated(forRemoval = true)
        public BL setPalette(BiFunction<T, class_3300, Pair<List<Palette>, @Nullable McMetaFile>> paletteProvider) {
            this.palette = (t, m) -> {
                var old = paletteProvider.apply(t, m);
                return PaletteStrategy.PaletteAndAnimation.of(old.getFirst(), old.getSecond());
            };
            return (BL) this;
        }

        //only works for oak type. Will fail if its used on leaves
        /// @deprecated Look at javadoc: {@link Builder#createPaletteFromChild(Consumer, String, Predicate)}
        @Deprecated(forRemoval = true)
        public BL createPaletteFromPlanks(Consumer<Palette> paletteTransform) {
            return createPaletteFromChild(paletteTransform, VanillaWoodChildKeys.PLANKS);
        }

        /// @deprecated Look at javadoc: {@link Builder#createPaletteFromChild(Consumer, String, Predicate)}
        @Deprecated(forRemoval = true)
        public BL createPaletteFromPlanks() {
            return createPaletteFromPlanks(p -> {
            });
        }

        /// @deprecated Look at javadoc: {@link Builder#createPaletteFromChild(Consumer, String, Predicate)}
        @Deprecated(forRemoval = true)
        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return createPaletteFromChild(paletteTransform, childKey, null);
        }

        /// @deprecated Look at javadoc: {@link Builder#createPaletteFromChild(Consumer, String, Predicate)}
        @Deprecated(forRemoval = true)
        public BL createPaletteFromChild(String childKey, Predicate<String> whichSide) {
            return createPaletteFromChild(p -> {
            }, childKey, whichSide);
        }

        /// @deprecated Look at javadoc: {@link Builder#createPaletteFromChild(Consumer, String, Predicate)}
        @Deprecated(forRemoval = true)
        public BL createPaletteFromChild(String childKey) {
            return createPaletteFromChild(p -> {
            }, childKey, null);
        }

        /**
         * @deprecated USE .addTexture() or .addTextureM(), the last parameter is PaletteStrategies<br>
         * Take a look at {@link PaletteStrategies} & Look for the FIELD which can be used as an argument for the last
         * parameter
        **/
        @Deprecated(forRemoval = true)
        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey, Predicate<String> whichSide) {
            return this.setPalette((blockType, m) -> {
                var p = PaletteStrategies.makePaletteFromChild(blockType, m, childKey, whichSide, paletteTransform);
                return Pair.of(p.palette(), p.animation());
            });
        }
    }


    @Nullable
    @Override
    //for null tab
    public class_1792 getItemForECTab(T type) {
        if (tab == null) {
            if (PlatHelper.isDev()) {
                throw new UnsupportedOperationException("Creative tab cant be null. Found null one for entry set: " + Utils.getID(this.getBaseType()).toString());
            }
            EveryCompat.LOGGER.error("Creative tab cant be null. Found null one for entry set: {}", Utils.getID(this.getBaseType()).toString());
            return null;
        }
        try {
            class_5321<class_1761> tagKey = tab.get();
            if (tagKey.method_29177().equals(NO_TAB_MARKER)) {
                return null;
            }
        } catch (Exception e) {
            if (PlatHelper.isDev()) throw e;
            EveryCompat.LOGGER.error("Failed to get creative tab for EntrySet - {} : {}", Utils.getID(this.getBaseType()).toString(), e);
            return null;
        }

        return EntrySet.super.getItemForECTab(type);
    }
}

