package net.mehvahdjukaar.every_compat.misc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;

/// Add models/block & models/item that need to be generated - Used by Gems-Realm
public record ModelConfiguration(Set<class_2960> blockModel, Set<class_2960> itemModel,
                                 boolean includeInGeneration) {

    public static final ModelConfiguration EMPTY = new ModelConfiguration(Set.of(), Set.of(), false);

    public static ModelConfiguration createNew() {
        return new ModelConfiguration(new HashSet<>(), new HashSet<>(), false);
    }

    public static ModelConfiguration createNew(boolean includeInGeneration) {
        return new ModelConfiguration(new HashSet<>(), new HashSet<>(), includeInGeneration);
    }

    /**
     * @param blockModels Add one or a list of models/block files
     **/
    public void addBlockModel(class_2960... blockModels) {
        this.blockModel.addAll(List.of(blockModels));
    }

    /**
     * @param itemModels Add a list of models/item files
     */
    public void addItemModel(class_2960... itemModels) {
        this.itemModel.addAll(List.of(itemModels));
    }

}

