package net.mehvahdjukaar.every_compat.modules.building_but_better;

import com.starfish_studios.bbb.block.*;
import com.starfish_studios.bbb.item.DescriptionBlockItem;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2465;
import net.minecraft.class_2510;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_7924;
import java.util.Objects;

import static net.mehvahdjukaar.every_compat.EveryCompat.res;
import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.STRIPPED_LOG;

//SUPPORT: v2.0pre3
public class BuildingButBetterModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> balustrade;
    public final SimpleEntrySet<WoodType, class_2248> beam;
    public final SimpleEntrySet<WoodType, class_2248> beam_slab;
    public final SimpleEntrySet<WoodType, class_2248> beam_stairs;
    public final SimpleEntrySet<WoodType, class_2248> frame;
    public final SimpleEntrySet<WoodType, class_2248> ladder;
    public final SimpleEntrySet<WoodType, class_2248> lantern;
    public final SimpleEntrySet<WoodType, class_2248> lattice;
    public final SimpleEntrySet<WoodType, class_2248> layer;
    public final SimpleEntrySet<WoodType, class_2248> pallet;
    public final SimpleEntrySet<WoodType, class_2248> support;
    public final SimpleEntrySet<WoodType, class_2248> trim;
    public final SimpleEntrySet<WoodType, class_2248> wall;

    public BuildingButBetterModule(String modId) {
        super(modId, "bbb");
        class_2960 tab = modRes("main");

        balustrade = SimpleEntrySet.builder(WoodType.class, "balustrade",
                        getModBlock("oak_balustrade"), () -> VanillaWoodTypes.OAK,
                        w -> new BalustradeBlock(Utils.copyPropertySafe(w.planks)
                                .method_22488()
                        )
                )
                //TEXTURES: beam/oak, planks
                .addTexture(modRes("block/balustrade/oak_sides"))
                .addTexture(modRes("block/balustrade/oak_top"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("balustrades"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
//                .defaultRecipe()
                .addCustomItem((woodType, block, properties) -> new DescriptionBlockItem(block, properties))
                .build();
        this.addEntry(balustrade);

        beam = SimpleEntrySet.builder(WoodType.class, "beam",
                        getModBlock("oak_beam"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2465(Utils.copyPropertySafe(Objects.requireNonNull(w.getBlockOfThis(STRIPPED_LOG))))
                )
                .requiresChildren(STRIPPED_LOG) //REASON: recipes
                .addTexture(modRes("block/beam/oak"), PaletteStrategies.STRIPPED_LOG_TOP_STANDARD)
                .addTexture(modRes("block/beam/oak_top"), PaletteStrategies.STRIPPED_LOG_TOP_STANDARD)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15471, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .addTag(new class_2960("alexscaves:grows_mussels"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addRecipe(modRes("oak_planks_from_beam"))
                .build();
        this.addEntry(beam);

        beam_slab = SimpleEntrySet.builder(WoodType.class, "beam_slab",
                        getModBlock("oak_beam_slab"), () -> VanillaWoodTypes.OAK,
                        w -> new FacingSlabBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresFromMap(beam.blocks) //REASON: recipes
                //TEXTURES: beam/oak
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15469, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .addRecipe(modRes("oak_planks_from_beam_slab"))
                .build();
        this.addEntry(beam_slab);

        beam_stairs = SimpleEntrySet.builder(WoodType.class, "beam_stairs",
                        getModBlock("oak_beam_stairs"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2510(w.planks.method_9564(), Utils.copyPropertySafe(w.planks))
                )
                .requiresFromMap(beam.blocks) //REASON: recipes
                //TEXTURES: beam/oak, beam/oak_top
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15459, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(beam_stairs);

        frame = SimpleEntrySet.builder(WoodType.class, "frame",
                        getModBlock("oak_frame"), () -> VanillaWoodTypes.OAK,
                        w -> new FrameBlock(Utils.copyPropertySafe(w.planks)
                                .method_22488()
                                .method_9634()
                        )
                )
                //TEXTURES: planks
                .addTexture(modRes("block/frame/oak"))
                .addTexture(modRes("block/frame/oak_sticks"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("wooden_frames"), class_7924.field_41254)
                .addTag(new class_2960("create:movable_empty_collider"), class_7924.field_41254)
                .addTag(modRes("frames"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((woodType, block, properties) -> new DescriptionBlockItem(block, properties))
                .build();
        this.addEntry(frame);

        ladder = SimpleEntrySet.builder(WoodType.class, "ladder",
                        getModBlock("oak_ladder"), () -> VanillaWoodTypes.OAK,
                        w -> new BBBLadderBlock(1, Utils.copyPropertySafe(class_2246.field_9983))
                )
                .addTexture(modRes("block/ladder/oak/oak"))
                .addTexture(modRes("block/ladder/acacia/oak"))
                .addTexture(modRes("block/ladder/birch/oak"))
                .addTexture(modRes("block/ladder/cherry/oak"))
                .addTexture(modRes("block/ladder/crimson/oak"))
                .addTexture(modRes("block/ladder/dark_oak/oak"))
                .addTexture(modRes("block/ladder/jungle/oak"))
                .addTexture(modRes("block/ladder/mangrove/oak"))
                .addTextureM(modRes("block/ladder/spruce/oak"), res("block/bbb/spruce-oak_ladder_m"))
                .addTexture(modRes("block/ladder/warped/oak"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_22414, class_7924.field_41254)
                .addTag(class_3481.field_36327, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("ladders"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .defaultRecipe()
                .addCustomItem((woodType, block, properties) -> new DescriptionBlockItem(block, properties))
                .build();
        this.addEntry(ladder);

        lantern = SimpleEntrySet.builder(WoodType.class, "lantern",
                        getModBlock("oak_lantern"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenLanternBlock(Utils.copyPropertySafe(w.planks)
                                .method_9631((blockStatex) -> 15)
                                .method_22488()
                                .method_50012(class_3619.field_15971)
                                .method_9632(0.3F))
                )
                //TEXTURES: planks
                .addTexture(modRes("block/lantern/oak"))
//                .addTextureM(modRes("block/lantern/oak"), EveryCompat.res("block/bbb/oak_lantern_m")) //REASON: the texture is 18x16, mask_texture had to be removed
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("wooden_lanterns"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(lantern);

        lattice = SimpleEntrySet.builder(WoodType.class, "lattice",
                        getModBlock("oak_lattice"), () -> VanillaWoodTypes.OAK,
                        w -> new LatticeBlock(Utils.copyPropertySafe(w.planks)
                                .method_22488().method_50012(class_3619.field_15971)
                        )
                )
                //TEXTURES: planks, log, log_top, leaves
                .addTexture(modRes("block/lattice/oak"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_22414, class_7924.field_41254)
                .addTag(class_3481.field_36327, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("lattices"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
//                .defaultRecipe() //TODO: no recipe available - waiting for DEV to add it
                .addCustomItem((woodType, block, properties) -> new DescriptionBlockItem(block, properties))
                .build();
        this.addEntry(lattice);

        layer = SimpleEntrySet.builder(WoodType.class, "layer",
                        getModBlock("oak_layer"), () -> VanillaWoodTypes.OAK,
                        w -> new LayerBlock(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("wooden_layers"), class_7924.field_41254, class_7924.field_41197)
                .addTag(modRes("layers"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((woodType, block, properties) -> new DescriptionBlockItem(block, properties))
                .build();
        this.addEntry(layer);

        pallet = SimpleEntrySet.builder(WoodType.class, "pallet",
                        getModBlock("oak_pallet"), () -> VanillaWoodTypes.OAK,
                        w -> new PalletBlock(Utils.copyPropertySafe(w.planks)
                                .method_22488()
                        )
                )
                //TEXTURES: planks
                .addTexture(modRes("block/pallet/oak_pallet"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("pallets"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((woodType, block, properties) -> new DescriptionBlockItem(block, properties))
                .build();
        this.addEntry(pallet);

        support = SimpleEntrySet.builder(WoodType.class, "support",
                        getModBlock("oak_support"), () -> VanillaWoodTypes.OAK,
                        w -> new SupportBlock(Utils.copyPropertySafe(w.planks)
                                .method_22488()
                        )
                )
                //TEXTURES: beam/oak, beam/oak_top
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41254, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .addCustomItem((woodType, block, properties) -> new DescriptionBlockItem(block, properties))
                .build();
        this.addEntry(support);

        trim = SimpleEntrySet.builder(WoodType.class, "trim",
                        getModBlock("oak_trim"), () -> VanillaWoodTypes.OAK,
                        w -> new FacingConnectingBlock(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTexture(modRes("block/sanded_planks/oak"))
                .addTexture(modRes("block/trim/oak"))
                .addTexture(modRes("block/trim/oak_bottom"))
                .addTexture(modRes("block/trim/oak_middle"))
                .addTexture(modRes("block/trim/oak_top"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("trims"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(trim);

        wall = SimpleEntrySet.builder(WoodType.class, "wall",
                        getModBlock("oak_wall"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenWallBlock(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: beam/oak, beam/oak_top
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("wooden_walls"), class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(wall);


    }
}