package net.mehvahdjukaar.every_compat.modules.decorative_blocks;

import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBBlocks;
import lilypuree.decorative_blocks.items.SeatItem;
import lilypuree.decorative_blocks.items.SupportItem;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.api.TextureInfo;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_7924;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

//SUPPORT: v4.1.3+
public class DecorativeBlocksModule extends SimpleModule {

    public final Map<WoodType, DBWoodType> wtConversion = new HashMap<>();
    public final SimpleEntrySet<WoodType, class_2248> beams;
    public final SimpleEntrySet<WoodType, class_2248> palisades;
    public final SimpleEntrySet<WoodType, class_2248> supports;
    public final SimpleEntrySet<WoodType, class_2248> seats;

    public DecorativeBlocksModule(String modId) {
        super(modId, "db");
        class_2960 tab = modRes("general");

        beams = SimpleEntrySet.builder(WoodType.class, "beam",
                        getModBlock("oak_beam"), () -> VanillaWoodTypes.OAK,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.BEAM)
                )
                .requiresChildren("stripped_log") //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_35571, class_7924.field_41254)
                .addTag(class_3481.field_15475, class_7924.field_41254)
                .addTag(class_3481.field_23210, class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .addTag(modRes("beams_that_burn"), class_7924.field_41254)
                .addTag(class_3489.field_15539, class_7924.field_41197)
                .addTag(class_3489.field_23212, class_7924.field_41197)
                .addTag(modRes("beams"), class_7924.field_41197)
                .addTag(modRes("beams_that_burn"), class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .addTexture(TextureInfo.of(modRes("block/oak_beam_end"))
                        .palette(PaletteStrategies.SIGN_LIKE))
                .addTexture(TextureInfo.of(modRes("block/oak_beam_side"))
                        .palette(PaletteStrategies.SIGN_LIKE))
                .build();
        this.addEntry(beams);


        palisades = SimpleEntrySet.builder(WoodType.class, "palisade",
                        getModBlock("oak_palisade"), () -> VanillaWoodTypes.OAK,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.PALISADE)
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .addTag(modRes("palisades"), class_7924.field_41254)
                .addTag(modRes("palisades_that_burn"), class_7924.field_41254)
                .addTag(modRes("palisades"), class_7924.field_41197)
                .addTag(modRes("palisades_that_burn"), class_7924.field_41197)
                .defaultRecipe()
                .setTabKey(tab)
                .addTexture(TextureInfo.of(modRes("block/oak_palisade_end"))
                        .palette(PaletteStrategies.SIGN_LIKE))
                .addTexture(TextureInfo.of(modRes("block/oak_palisade_side"))
                        .palette(PaletteStrategies.SIGN_LIKE))
                .build();
        this.addEntry(palisades);


        supports = SimpleEntrySet.builder(WoodType.class, "support",
                        getModBlock("oak_support"), () -> VanillaWoodTypes.OAK,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.SUPPORT)
                )
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41254)
                .addTag(modRes("supports_that_burn"), class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41197)
                .addTag(modRes("supports_that_burn"), class_7924.field_41197)
                .addCustomItem((w, b, p) -> new SupportItem(b, p))
                .defaultRecipe()
                .setTabKey(tab)
                .addTexture(TextureInfo.of(modRes("block/oak_support_end"))
                        .palette(PaletteStrategies.SIGN_LIKE))
                .addTexture(TextureInfo.of(modRes("block/oak_support_side"))
                        .palette(PaletteStrategies.SIGN_LIKE))
                .build();
        this.addEntry(supports);


        seats = SimpleEntrySet.builder(WoodType.class, "seat",
                        getModBlock("oak_seat"), () -> VanillaWoodTypes.OAK,
                        w -> DBBlocks.createDecorativeBlock(wtConversion.get(w), WoodDecorativeBlockTypes.SEAT)
                )
                .requiresChildren("fence", "slab") //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("seats_that_burn"), class_7924.field_41254)
                .addTag(modRes("seats"), class_7924.field_41254)
                .addTag(modRes("seats"), class_7924.field_41197)
                .defaultRecipe()
                .addCustomItem((w, b, p) -> new SeatItem(b, p))
                .setTabKey(tab)
                .addTexture(TextureInfo.of(modRes("block/oak_seat"))
                        .palette(PaletteStrategies.SIGN_LIKE))
                .build();
        this.addEntry(seats);

    }


    @Override
    public <T extends BlockType> void registerBlocks(Class<T> typeClass,
                                                     Registrator<class_2248> registry, Collection<T> types) {
        if (typeClass == WoodType.class) {
            types.forEach(w -> wtConversion.put((WoodType) w, new DBWoodType((WoodType) w)));
        }
        super.registerBlocks(typeClass, registry, types);
    }

}