/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.configs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class WoodConfigs {
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> BLOCK_TYPE_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> CHILD_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    public static ConfigSpec SPEC;

    public static void init() {
        Map map;
        Supplier config;
        String key;
        String ss = PlatformHelper.isDev() && PlatformHelper.getEnv().isServer() ? "_s" : "";
        ConfigBuilder builder = ConfigBuilder.create((ResourceLocation)EveryCompat.res("wood_types" + ss), (ConfigType)ConfigType.COMMON);
        builder.push("types");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            builder.push(reg.typeName().replace(" ", "_"));
            for (BlockType w : reg.getValues()) {
                if (w.isVanilla()) continue;
                key = w.toString().replace(":", ".");
                config = builder.define(key, true);
                map = BLOCK_TYPE_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(w.toString(), config);
            }
            builder.pop();
        }
        builder.pop();
        builder.push("entries");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            if (reg.getType() != WoodType.class && reg.getType() != LeavesType.class) continue;
            builder.push(reg.typeName().replace(" ", "_"));
            for (String c : EveryCompat.ENTRY_TYPES.getOrDefault(reg.getType(), Set.of())) {
                key = c.replace(":", ".");
                config = builder.define(key, true);
                map = CHILD_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(c, config);
            }
            builder.pop();
        }
        builder.pop();
        SPEC = builder.buildAndRegister();
        SPEC.loadFromFile();
    }

    public static <T extends BlockType> boolean isEntryEnabled(T w, Object o) {
        return WoodConfigs.isTypeEnabled(w, w.getChildKey(o));
    }

    public static <T extends BlockType> boolean isEntryEnabled(Class<T> typeClass, Object o) {
        BlockType w = BlockSetAPI.getBlockTypeOf((ItemLike)((ItemLike)o), typeClass);
        return WoodConfigs.isTypeEnabled(w, w.getChildKey(o));
    }

    public static <T extends BlockType> boolean isTypeEnabled(T w) {
        return WoodConfigs.isTypeEnabled(w, null);
    }

    public static <T extends BlockType> boolean isTypeEnabled(T w, @Nullable String childType) {
        try {
            if (childType != null && !CHILD_CONFIGS.get(w.getClass()).getOrDefault(childType, () -> true).get().booleanValue()) {
                return false;
            }
            return BLOCK_TYPE_CONFIGS.get(w.getClass()).get(w.getId().toString()).get();
        }
        catch (Exception exception) {
            return true;
        }
    }
}

