/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.misc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcesUtils {
    private static final JsonObject DUMMY_BLOCKSTATE = new JsonObject();

    public static <B extends Block, T extends BlockType> void addStandardResources(String modId, ResourceManager manager, DynClientResourcesProvider pack, Map<T, B> blocks, T baseType) {
        ResourcesUtils.addStandardResources(modId, manager, pack, blocks, baseType, null);
    }

    public static <B extends Block, T extends BlockType> void addStandardResources(String modId, ResourceManager manager, DynClientResourcesProvider d, Map<T, B> blocks, T baseType, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        if (blocks.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)blocks.entrySet().stream().findFirst().get();
        Block oakBlock = BlockType.changeBlockType((Block)((Block)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        String baseBlockName = baseType.getTypeName();
        if (oakBlock == null) {
            EveryCompat.LOGGER.error("Failed to generate some assets");
            return;
        }
        ResourceLocation oakId = Utils.getID((Block)oakBlock);
        BlockTypeResTransformer modifier = BlockTypeResTransformer.create((String)modId, (ResourceManager)manager);
        modifier.IDReplaceType(baseBlockName).replaceBlockType(baseBlockName);
        if (extraTransform != null) {
            extraTransform.accept(modifier);
        }
        BlockTypeResTransformer modelModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseBlockName, extraTransform);
        HashSet modelsLoc = new HashSet();
        Item oakItem = oakBlock.m_5456_();
        if (oakItem != Items.f_41852_) {
            try {
                String parent;
                BlockTypeResTransformer itemModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseBlockName, extraTransform);
                StaticResource oakItemModel = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Utils.getID((Item)oakItem)));
                JsonObject json = RPUtils.deserializeJson((InputStream)oakItemModel.getInputStream());
                modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
                if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                    itemModifier.replaceItemType(baseBlockName);
                }
                blocks.forEach((w, b) -> {
                    ResourceLocation id = Utils.getID((Block)b);
                    try {
                        StaticResource newRes = itemModifier.transform(oakItemModel, id, w);
                        assert (newRes.location != oakItemModel.location) : "ids cant be the same";
                        d.addResourceIfNotPresent(manager, newRes);
                    }
                    catch (Exception e) {
                        EveryCompat.LOGGER.error("Failed to add {} item model json file:", b, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Could not find item model for {}", (Object)oakBlock);
            }
        }
        try {
            StaticResource oakBlockstate = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(oakId));
            JsonObject json = RPUtils.deserializeJson((InputStream)oakBlockstate.getInputStream());
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model")));
            ArrayList<StaticResource> oakModels = new ArrayList<StaticResource>();
            for (String m : modelsLoc) {
                StaticResource model;
                ResourceLocation modelRes = new ResourceLocation(m);
                if (modelRes.m_135827_().equals("minecraft") || (model = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.MODELS.getPath(m))) == null) continue;
                oakModels.add(model);
            }
            blocks.forEach((w, b) -> {
                ResourceLocation id = Utils.getID((Block)b);
                try {
                    StaticResource newBlockState = modifier.transform(oakBlockstate, id, w);
                    assert (newBlockState.location != oakBlockstate.location) : "ids cant be the same";
                    d.addResourceIfNotPresent(manager, newBlockState);
                    for (StaticResource model : oakModels) {
                        try {
                            StaticResource newModel = modelModifier.transform(model, id, w);
                            assert (newModel.location != model.location) : "ids cant be the same";
                            d.addResourceIfNotPresent(manager, newModel);
                        }
                        catch (Exception exception) {
                            EveryCompat.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                        }
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} blockstate json file:", b, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find blockstate definition for {}", (Object)oakBlock);
        }
    }

    public static <I extends Item, T extends BlockType> void addItemModels(String modId, ResourceManager manager, DynClientResourcesProvider d, Map<T, I> items, T baseType, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        if (items.isEmpty()) {
            return;
        }
        Map.Entry first = (Map.Entry)items.entrySet().stream().findFirst().get();
        Item oakItem = BlockType.changeItemType((Item)((Item)first.getValue()), (BlockType)((BlockType)first.getKey()), baseType);
        String baseItemname = baseType.getTypeName();
        if (oakItem == null) {
            EveryCompat.LOGGER.error("Failed to generate some assets");
            return;
        }
        BlockTypeResTransformer modifier = BlockTypeResTransformer.create((String)modId, (ResourceManager)manager);
        modifier.IDReplaceType(baseItemname).replaceBlockType(baseItemname);
        if (extraTransform != null) {
            extraTransform.accept(modifier);
        }
        BlockTypeResTransformer modelModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseItemname, extraTransform);
        HashSet modelsLoc = new HashSet();
        try {
            String parent;
            BlockTypeResTransformer itemModifier = ResourcesUtils.standardModelTransformer(modId, manager, baseType, baseItemname, extraTransform);
            StaticResource oakItemModel = StaticResource.getOrFail((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Utils.getID((Item)oakItem)));
            JsonObject json = RPUtils.deserializeJson((InputStream)oakItemModel.getInputStream());
            modelsLoc.addAll(RPUtils.findAllResourcesInJsonRecursive((JsonElement)json, s -> s.equals("model") || s.equals("parent")));
            if (json.has("parent") && (parent = json.get("parent").getAsString()).contains("item/generated")) {
                itemModifier.replaceItemType(baseItemname);
            }
            items.forEach((w, b) -> {
                ResourceLocation id = Utils.getID((Item)b);
                try {
                    StaticResource newRes = itemModifier.transform(oakItemModel, id, w);
                    assert (newRes.location != oakItemModel.location) : "ids cant be the same";
                    d.addResourceIfNotPresent(manager, newRes);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to add {} item model json file:", b, (Object)e);
                }
            });
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not find item model for {}", (Object)oakItem);
        }
        ArrayList<StaticResource> oakModels = new ArrayList<StaticResource>();
        for (String m : modelsLoc) {
            StaticResource model;
            ResourceLocation modelRes = new ResourceLocation(m);
            if (modelRes.m_135827_().equals("minecraft") || (model = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.MODELS.getPath(m))) == null) continue;
            oakModels.add(model);
        }
        items.forEach((w, b) -> {
            ResourceLocation id = Utils.getID((Item)b);
            for (StaticResource model : oakModels) {
                try {
                    StaticResource newModel = modelModifier.transform(model, id, w);
                    assert (newModel.location != model.location) : "ids cant be the same";
                    d.addResourceIfNotPresent(manager, newModel);
                }
                catch (Exception exception) {
                    EveryCompat.LOGGER.error("Failed to add {} model json file:", b, (Object)exception);
                }
            }
        });
    }

    @NotNull
    private static <T extends BlockType> BlockTypeResTransformer<T> standardModelTransformer(String modId, ResourceManager manager, T baseType, String oldTypeName, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        BlockTypeResTransformer modelModifier = BlockTypeResTransformer.create((String)modId, (ResourceManager)manager);
        if (extraTransform != null) {
            extraTransform.accept(modelModifier);
        }
        modelModifier.IDReplaceType(oldTypeName);
        if (baseType instanceof LeavesType) {
            LeavesType leavesType = (LeavesType)baseType;
            modelModifier.replaceLeavesTextures(leavesType);
            WoodType woodT = leavesType.getWoodType();
            if (woodT != null) {
                modelModifier.replaceWoodTextures(woodT);
            }
        } else if (baseType instanceof WoodType) {
            WoodType woodType = (WoodType)baseType;
            modelModifier.replaceWoodTextures(woodType);
        }
        modelModifier.replaceGenericType(oldTypeName, "block");
        return modelModifier;
    }

    public static <B extends Block, T extends BlockType> void addBlockResources(String modId, ResourceManager manager, DynamicResourcePack pack, Map<T, B> blocks, String typeName, ResourceLocation ... jsonsLocations) {
        ResourcesUtils.addBlockResources(modId, manager, pack, blocks, BlockTypeResTransformer.create((String)modId, (ResourceManager)manager).replaceSimpleType(typeName).IDReplaceType(typeName), jsonsLocations);
    }

    public static <B extends Block, T extends BlockType> void addBlockResources(String modId, ResourceManager manager, DynamicResourcePack pack, Map<T, B> blocks, BlockTypeResTransformer<T> modifier, ResourceLocation ... jsonsLocations) {
        List<StaticResource> original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)s)).toList();
        blocks.forEach((wood, value) -> {
            if (WoodConfigs.isEntryEnabled(wood, value)) {
                for (StaticResource res : original) {
                    try {
                        StaticResource newRes = modifier.transform(res, Utils.getID((Block)value), wood);
                        assert (newRes.location != res.location) : "ids cant be the same";
                        pack.addResource(newRes);
                    }
                    catch (Exception e) {
                        if (res == null) continue;
                        EveryCompat.LOGGER.error("Failed to generate json resource from {}", (Object)res.location);
                    }
                }
            }
        });
    }

    public static void addLeavesRecipes(String modId, ResourceManager manager, DynamicDataPack pack, Map<LeavesType, Item> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, LeavesTypeRegistry.OAK_TYPE);
    }

    public static <B extends Item> void addWoodRecipes(String modId, ResourceManager manager, DynamicDataPack pack, Map<WoodType, B> blocks, String oakRecipe) {
        ResourcesUtils.addBlocksRecipes(modId, manager, pack, blocks, oakRecipe, WoodTypeRegistry.OAK_TYPE);
    }

    public static <B extends Item, T extends BlockType> void addBlocksRecipes(String modId, ResourceManager manager, DynamicDataPack pack, Map<T, B> blocks, String oakRecipe, T fromType) {
        ResourcesUtils.addBlocksRecipes(manager, pack, blocks, new ResourceLocation(modId, oakRecipe), fromType, 0);
    }

    public static <B extends Item, T extends BlockType> void addBlocksRecipes(ResourceManager manager, DynamicDataPack pack, Map<T, B> items, ResourceLocation oakRecipe, T fromType, int index) {
        IRecipeTemplate template = RPUtils.readRecipeAsTemplate((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(oakRecipe));
        items.forEach((w, i) -> {
            if (WoodConfigs.isEntryEnabled(w, i)) {
                try {
                    if (i.m_41471_() != null) {
                        FinishedRecipe newR;
                        Object id = RecipeBuilder.m_176493_((ItemLike)i).toString();
                        if (index != 0) {
                            id = (String)id + "_" + index;
                            newR = template.createSimilar(fromType, w, w.mainChild().m_5456_(), (String)id);
                        } else {
                            newR = template.createSimilar(fromType, w, w.mainChild().m_5456_());
                        }
                        if (newR == null) {
                            EveryCompat.LOGGER.error("Failed to generate recipe for {}: recipe template returned null", i);
                            return;
                        }
                        newR = ForgeHelper.addRecipeConditions((FinishedRecipe)newR, (List)template.getConditions());
                        pack.addRecipe(newR);
                    }
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to generate recipe for {}:", i, (Object)e);
                }
            }
        });
    }

    public static <T extends BlockType> Ingredient convertIngredient(Ingredient ingredient, T originalMat, T destinationMat) {
        Ingredient newIng = ingredient;
        for (ItemStack in : ingredient.m_43908_()) {
            Item i;
            Item it = in.m_41720_();
            if (it == Items.f_42127_ || (i = BlockType.changeItemType((Item)it, originalMat, destinationMat)) == null) continue;
            newIng = Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
            break;
        }
        return newIng;
    }

    static {
        DUMMY_BLOCKSTATE.addProperty("parent", "block/cube_all");
        JsonObject t = new JsonObject();
        t.addProperty("all", "everycomp:block/disabled");
        DUMMY_BLOCKSTATE.add("textures", (JsonElement)t);
    }
}

