/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.abnormal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamabnormals.blueprint.client.ChestManager;
import com.teamabnormals.blueprint.client.renderer.block.ChestBlockEntityWithoutLevelRenderer;
import com.teamabnormals.blueprint.common.block.BlueprintBeehiveBlock;
import com.teamabnormals.blueprint.common.block.BlueprintLadderBlock;
import com.teamabnormals.blueprint.common.block.BookshelfBlock;
import com.teamabnormals.blueprint.common.block.LeafPileBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.entity.BlueprintChestBlockEntity;
import com.teamabnormals.blueprint.common.block.entity.BlueprintTrappedChestBlockEntity;
import com.teamabnormals.blueprint.common.item.BEWLRBlockItem;
import com.teamabnormals.blueprint.common.item.BEWLRFuelBlockItem;
import com.teamabnormals.blueprint.core.other.tags.BlueprintItemTags;
import com.teamabnormals.blueprint.core.registry.BlueprintBlockEntityTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.common_classes.TagUtility;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class WoodworksModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "bookshelf", () -> this.getModBlock("acacia_bookshelf"), () -> WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("acacia")), w -> new BookshelfBlock(WoodworksBlocks.WoodworksProperties.ACACIA_WOOD.bookshelf())).setTab(() -> CreativeModeTab.f_40750_)).copyParentDrop().addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(Tags.Blocks.BOOKSHELVES, Registry.f_122901_)).addTag(Tags.Items.BOOKSHELVES, Registry.f_122904_)).addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))).defaultRecipe().build();
    public final SimpleEntrySet<WoodType, Block> boards;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> beehives;
    public final SimpleEntrySet<WoodType, Block> chests;
    public final SimpleEntrySet<WoodType, Block> trappedChests;
    public final SimpleEntrySet<LeavesType, Block> leafPiles;

    public WoodworksModule(String modId) {
        super(modId, "abnww");
        this.addEntry(this.bookshelves);
        this.boards = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "boards", WoodworksBlocks.OAK_BOARDS, () -> WoodTypeRegistry.OAK_TYPE, w -> new RotatedPillarBlock(Utils.copyPropertySafe((BlockBehaviour)w.planks))).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTexture(this.modRes("block/oak_boards"))).defaultRecipe().build();
        this.addEntry(this.boards);
        this.ladders = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "ladder", () -> this.getModBlock("spruce_ladder"), () -> WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("spruce")), w -> new BlueprintLadderBlock(WoodworksBlocks.WoodworksProperties.OAK_WOOD.ladder())).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_13082_, Registry.f_122901_)).addTag(new ResourceLocation("quark:ladders"), Registry.f_122901_)).addTag(new ResourceLocation("quark:ladders"), Registry.f_122904_)).defaultRecipe().addTexture(EveryCompat.res("block/spruce_ladder"))).build();
        this.addEntry(this.ladders);
        this.beehives = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "beehive", () -> this.getModBlock("spruce_beehive"), () -> WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("spruce")), w -> new BlueprintBeehiveBlock(WoodworksBlocks.WoodworksProperties.OAK_WOOD.beehive())).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(BlockTags.f_13072_, Registry.f_122901_)).defaultRecipe().addTile(BlueprintBlockEntityTypes.BEEHIVE).addTextureM(EveryCompat.res("block/spruce_beehive_front_honey"), EveryCompat.res("block/spruce_beehive_front_honey_m"))).addTextureM(EveryCompat.res("block/spruce_beehive_front"), EveryCompat.res("block/spruce_beehive_front_m"))).addTextureM(EveryCompat.res("block/spruce_beehive_side"), EveryCompat.res("block/spruce_beehive_side_m"))).addTexture(EveryCompat.res("block/spruce_beehive_end"))).build();
        this.addEntry(this.beehives);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "chest", () -> this.getModBlock("oak_chest"), () -> WoodTypeRegistry.OAK_TYPE, w -> new BlueprintChestBlock("everycomp:" + w.getTypeName(), WoodworksBlocks.WoodworksProperties.OAK_WOOD.chest())).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(BlockTags.f_13088_, Registry.f_122901_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122901_)).addTag(Tags.Blocks.CHESTS, Registry.f_122901_)).addTag(Tags.Items.CHESTS, Registry.f_122904_)).addTag(Tags.Items.CHESTS_WOODEN, Registry.f_122904_)).addTag(BlueprintItemTags.BOATABLE_CHESTS, Registry.f_122904_)).addTag(BlueprintItemTags.REVERTABLE_CHESTS, Registry.f_122904_)).addTile(BlueprintChestBlockEntity::new).addCustomItem((w, b, p) -> new BEWLRFuelBlockItem(b, p, () -> () -> WoodworksModule.chestBEWLR(false), 300)).defaultRecipe().build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "trapped_chest", () -> this.getModBlock("oak_trapped_chest"), () -> WoodTypeRegistry.OAK_TYPE, w -> new BlueprintTrappedChestBlock("everycomp:" + w.getTypeName() + "_trapped", WoodworksBlocks.WoodworksProperties.OAK_WOOD.chest())).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(BlockTags.f_13088_, Registry.f_122901_)).addTag(Tags.Blocks.CHESTS, Registry.f_122901_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122901_)).addTag(Tags.Blocks.CHESTS_TRAPPED, Registry.f_122901_)).addTag(Tags.Items.CHESTS, Registry.f_122904_)).addTag(Tags.Items.CHESTS_TRAPPED, Registry.f_122904_)).addTag(Tags.Items.CHESTS_WOODEN, Registry.f_122904_)).addTile(BlueprintTrappedChestBlockEntity::new).addCustomItem((w, b, p) -> new BEWLRFuelBlockItem(b, p, () -> () -> WoodworksModule.chestBEWLR(true), 300)).build();
        this.addEntry(this.trappedChests);
        this.leafPiles = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(LeavesType.class, "leaf_pile", WoodworksBlocks.OAK_LEAF_PILE, () -> LeavesTypeRegistry.OAK_TYPE, w -> {
            if (w.getWoodType() == null) {
                return null;
            }
            return new LeafPileBlock(WoodworksBlocks.WoodworksProperties.OAK_WOOD.leafPile());
        }).addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", s -> !s.contains("/snow") && !s.contains("_snow")))).addTag(BlockTags.f_144281_, Registry.f_122901_)).addTag(this.modRes("leaf_piles"), Registry.f_122901_)).setTab(() -> CreativeModeTab.f_40749_)).setRenderType(() -> RenderType::m_110463_).copyParentDrop().defaultRecipe().build();
        this.addEntry(this.leafPiles);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer(dispatcher, entityModelSet, (BlockEntity)new BlueprintChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }

    @Override
    public void registerBlockColors(ClientPlatformHelper.BlockColorEvent event) {
        super.registerBlockColors(event);
        this.leafPiles.blocks.forEach((t, b) -> event.register((s, l, p, i) -> event.getColor(t.leaves.m_49966_(), l, p, i), new Block[]{b}));
    }

    @Override
    public void registerItemColors(ClientPlatformHelper.ItemColorEvent event) {
        this.leafPiles.blocks.forEach((t, b) -> event.register((stack, tintIndex) -> event.getColor(new ItemStack((ItemLike)t.leaves), tintIndex), new ItemLike[]{b.m_5456_()}));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        for (WoodType wood2 : this.trappedChests.blocks.keySet()) {
            Block chest = this.chests.blocks.get(wood2) == null ? (Block)Registry.f_122824_.m_7745_(new ResourceLocation(wood2.getNamespace(), wood2.getTypeName() + "_chest")) : (Block)this.chests.blocks.get(wood2);
            this.createChestRecipe(chest, (Block)this.trappedChests.blocks.get(wood2), handler, manager, wood2);
        }
        this.bookshelves.items.forEach((wood, item) -> {
            this.sawmill_Recipe("oak_planks_from_oak_logs_sawing", wood.log.m_5456_(), wood.planks.m_5456_(), handler, manager, (WoodType)wood);
            this.sawmill_Recipe("oak_boards_from_oak_logs_sawing", wood.log.m_5456_(), (Item)this.boards.items.get(wood), handler, manager, (WoodType)wood);
            this.sawmill_Recipe("spruce_ladder_from_spruce_logs_sawing", wood.log.m_5456_(), (Item)this.ladders.items.get(wood), handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_button_from_oak_logs_sawing", true, "button", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_door_from_oak_logs_sawing", true, "door", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_fence_from_oak_logs_sawing", true, "fence", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_fence_gate_from_oak_logs_sawing", true, "fence_gate", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_pressure_plate_from_oak_logs_sawing", true, "pressure_plate", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_sign_from_oak_logs_sawing", true, "sign", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_slab_from_oak_logs_sawing", true, "slab", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_stairs_from_oak_logs_sawing", true, "stairs", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_trapdoor_from_oak_logs_sawing", true, "trapdoor", handler, manager, (WoodType)wood);
            this.sawmill_Recipe("oak_boards_from_oak_planks_sawing", wood.planks.m_5456_(), (Item)this.boards.items.get(wood), handler, manager, (WoodType)wood);
            this.sawmill_Recipe("spruce_ladder_from_spruce_planks_sawing", wood.planks.m_5456_(), (Item)this.ladders.items.get(wood), handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_button_from_oak_planks_sawing", false, "button", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_fence_from_oak_planks_sawing", false, "fence", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_slab_from_oak_planks_sawing", false, "slab", handler, manager, (WoodType)wood);
            this.createRecipe_ifNotNull("oak_stairs_from_oak_planks_sawing", false, "stairs", handler, manager, (WoodType)wood);
        });
    }

    public void createChestRecipe(Block input, Block output, ServerDynamicResourcesHandler handler, ResourceManager manager, WoodType wood) {
        String trappedChest = "oak_trapped_chest";
        ResourceLocation recipeLoc = this.modRes(trappedChest);
        try (InputStream recipeStream = ((Resource)manager.m_213713_(ResType.RECIPES.getPath(recipeLoc)).orElseThrow(() -> new FileNotFoundException("File not found @ " + recipeLoc))).m_215507_();){
            JsonObject jsonObj = RPUtils.deserializeJson((InputStream)recipeStream);
            JsonObject underRecipes = jsonObj.getAsJsonArray("recipes").get(0).getAsJsonObject();
            JsonObject underIngredients = underRecipes.getAsJsonObject("recipe").getAsJsonArray("ingredients").get(0).getAsJsonObject();
            String newTrappedChest = trappedChest.replace("oak", wood.getAppendableId());
            ResourceLocation newResLoc = EveryCompat.res(this.shortenedId() + "/" + newTrappedChest);
            underIngredients.addProperty("item", Utils.getID((Block)input).toString());
            underRecipes.getAsJsonObject("recipe").getAsJsonObject("result").addProperty("item", Utils.getID((Block)output).toString());
            ((DynamicDataPack)handler.dynamicPack).addJson(newResLoc, (JsonElement)jsonObj, ResType.RECIPES);
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to generate recipe for {} : {}", (Object)Utils.getID((Block)output), (Object)e);
        }
    }

    public void createRecipe_ifNotNull(String recipeName, boolean usingLog, String output, ServerDynamicResourcesHandler handler, ResourceManager manager, WoodType wood) {
        Item input;
        Item item = input = usingLog ? wood.log.m_5456_() : wood.planks.m_5456_();
        if (Objects.nonNull(wood.getItemOfThis(output))) {
            this.sawmill_Recipe(recipeName, input, wood.getItemOfThis(output), handler, manager, wood);
        } else if (Objects.nonNull(wood.getBlockOfThis(output))) {
            this.sawmill_Recipe(recipeName, input, Objects.requireNonNull(wood.getBlockOfThis(output)).m_5456_(), handler, manager, wood);
        }
    }

    public void sawmill_Recipe(String recipeName, Item input, Item output, ServerDynamicResourcesHandler handler, ResourceManager manager, WoodType wood) {
        ResourceLocation recipeLocation = this.modRes("recipes/" + recipeName + ".json");
        JsonObject recipe = null;
        try (InputStream recipeStream = ((Resource)manager.m_213713_(recipeLocation).orElseThrow()).m_215507_();){
            recipe = RPUtils.deserializeJson((InputStream)recipeStream);
            JsonObject getRecipe = recipe.getAsJsonArray("recipes").get(0).getAsJsonObject().getAsJsonObject("recipe");
            JsonObject getIngredient = getRecipe.getAsJsonObject("ingredient");
            if (getIngredient.has("tag")) {
                getIngredient.addProperty("tag", TagUtility.whichTags("logs", "caps", wood, handler, manager).toString());
            } else {
                getIngredient.addProperty("item", Utils.getID((Item)input).toString());
            }
            getRecipe.addProperty("result", Utils.getID((Item)output).toString());
        }
        catch (IOException e) {
            EveryCompat.LOGGER.error("{Woodworks Module} sawmill_recipe(): {0}", (Throwable)e);
        }
        String[] nameSplit = recipeName.split("_(?!gate|plate)");
        String filenameBuilder = "_" + nameSplit[1] + "_from_" + wood.getTypeName() + "_" + nameSplit[4] + "_sawing";
        ((DynamicDataPack)handler.dynamicPack).addJson(EveryCompat.res(this.shortenedId() + "/" + wood.getAppendableId() + filenameBuilder), (JsonElement)recipe, ResType.RECIPES);
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        this.trappedChests.blocks.forEach((wood, block) -> {
            BlueprintTrappedChestBlock b = (BlueprintTrappedChestBlock)block;
            String folderPath = "entity/chest/";
            ResourceLocation res = EveryCompat.res(folderPath + wood.getTypeName() + "/normal");
            ResourceLocation trappedRes = EveryCompat.res(folderPath + wood.getTypeName() + "/trapped");
            CompatChestTexture.generateChestTexture(handler, manager, wood, block, res, trappedRes, this.modRes("entity/chest/oak/normal"), EveryCompat.res("model/oak_chest_normal_m"), EveryCompat.res("model/oak_chest_normal_o"), EveryCompat.res("model/trapped_chest_normal"));
            res = EveryCompat.res(folderPath + wood.getTypeName() + "/normal_left");
            trappedRes = EveryCompat.res(folderPath + wood.getTypeName() + "/trapped_left");
            CompatChestTexture.generateChestTexture(handler, manager, wood, block, res, trappedRes, this.modRes("entity/chest/oak/normal_left"), EveryCompat.res("model/oak_chest_left_m"), EveryCompat.res("model/oak_chest_left_o"), EveryCompat.res("model/trapped_chest_left"));
            res = EveryCompat.res(folderPath + wood.getTypeName() + "/normal_right");
            trappedRes = EveryCompat.res(folderPath + wood.getTypeName() + "/trapped_right");
            CompatChestTexture.generateChestTexture(handler, manager, wood, block, res, trappedRes, this.modRes("entity/chest/oak/normal_right"), EveryCompat.res("model/oak_chest_right_m"), EveryCompat.res("model/oak_chest_right_o"), EveryCompat.res("model/trapped_chest_right"));
            if (this.chests.blocks.get(wood) != null) {
                ChestManager.putChestInfo((String)"everycomp", (String)wood.getTypeName(), (boolean)false);
            }
            ChestManager.putChestInfo((String)"everycomp", (String)wood.getTypeName(), (boolean)true);
        });
    }
}

