/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.quark;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.common_classes.CompatChestTexture;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.modules.forge.quark.CompatChestBlock;
import net.mehvahdjukaar.every_compat.modules.forge.quark.CompatChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.forge.quark.CompatTrappedChestBlock;
import net.mehvahdjukaar.every_compat.modules.forge.quark.CompatTrappedChestBlockTile;
import net.mehvahdjukaar.every_compat.modules.forge.quark.QuarkSimpleEntrySet;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.function.TriFunction;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.ToolInteractionHandler;
import vazkii.quark.content.building.block.HedgeBlock;
import vazkii.quark.content.building.block.HollowLogBlock;
import vazkii.quark.content.building.block.LeafCarpetBlock;
import vazkii.quark.content.building.block.VariantBookshelfBlock;
import vazkii.quark.content.building.block.VariantChestBlock;
import vazkii.quark.content.building.block.VariantLadderBlock;
import vazkii.quark.content.building.block.VariantTrappedChestBlock;
import vazkii.quark.content.building.block.WoodPostBlock;
import vazkii.quark.content.building.client.render.be.VariantChestRenderer;
import vazkii.quark.content.building.module.HedgesModule;
import vazkii.quark.content.building.module.HollowLogsModule;
import vazkii.quark.content.building.module.LeafCarpetModule;
import vazkii.quark.content.building.module.VariantBookshelvesModule;
import vazkii.quark.content.building.module.VariantChestsModule;
import vazkii.quark.content.building.module.VariantLaddersModule;
import vazkii.quark.content.building.module.VerticalPlanksModule;
import vazkii.quark.content.building.module.WoodenPostsModule;

public class QuarkModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> bookshelves;
    public final SimpleEntrySet<WoodType, Block> posts;
    public final SimpleEntrySet<WoodType, Block> strippedPosts;
    public final SimpleEntrySet<WoodType, Block> verticalPlanks;
    public final SimpleEntrySet<WoodType, Block> ladders;
    public final SimpleEntrySet<WoodType, Block> hollowLogs;
    public final SimpleEntrySet<WoodType, ? extends VariantChestBlock> chests;
    public final SimpleEntrySet<WoodType, ? extends VariantTrappedChestBlock> trappedChests;
    public final SimpleEntrySet<LeavesType, Block> hedges;
    public final SimpleEntrySet<LeavesType, Block> leafCarpets;
    public static BlockEntityType<? extends ChestBlockEntity> chestTile;
    public static BlockEntityType<? extends ChestBlockEntity> trappedChestTile;
    public final Field ARLModData;
    private static final ResourceLocation CHEST_SHEET;

    public QuarkModule(String modId) {
        super(modId, "q");
        Field f2 = null;
        try {
            f2 = ObfuscationReflectionHelper.findField(RegistryHelper.class, (String)"modData");
            f2.setAccessible(true);
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Failed to initialize {}: {}", (Object)this, (Object)e);
        }
        this.ARLModData = f2;
        this.bookshelves = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "bookshelf", VariantBookshelvesModule.class, () -> this.getModBlock("acacia_bookshelf"), () -> WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("acacia")), (w, m) -> new VariantBookshelfBlock(this.shortenedId() + "/" + w.getAppendableId(), m, w.canBurn())).setTab(() -> CreativeModeTab.f_40750_)).copyParentDrop().addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(Tags.Items.BOOKSHELVES, Registry.f_122901_)).addTag(Tags.Items.BOOKSHELVES, Registry.f_122904_)).addRecipe(this.modRes("building/crafting/acacia_bookshelf"))).addTextureM(EveryCompat.res("block/acacia_bookshelf"), EveryCompat.res("block/acacia_bookshelf_m"))).setPalette(this::bookshelfPalette)).build();
        this.addEntry(this.bookshelves);
        this.posts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", WoodenPostsModule.class, () -> this.getModBlock("oak_post"), () -> WoodTypeRegistry.OAK_TYPE, (w, m) -> {
            if (w.getNamespace().equals("malum")) {
                return null;
            }
            Block fence = w.getBlockOfThis("fence");
            return fence == null ? null : new WoodPostBlock(m, fence, this.shortenedId() + "/" + w.getNamespace() + "/", fence.m_49962_(fence.m_49966_()) == SoundType.f_56763_);
        }).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(this.modRes("posts"), Registry.f_122901_)).setTab(() -> CreativeModeTab.f_40750_)).addRecipe(this.modRes("building/crafting/oak_post"))).setRenderType(() -> RenderType::m_110463_).build();
        this.addEntry(this.posts);
        this.strippedPosts = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "post", "stripped", WoodenPostsModule.class, () -> this.getModBlock("stripped_oak_post"), () -> WoodTypeRegistry.OAK_TYPE, (w, m) -> {
            if (w.getNamespace().equals("malum") || w.getNamespace().equals("twigs")) {
                return null;
            }
            Block fence = w.getBlockOfThis("fence");
            Block stripped = w.getBlockOfThis("stripped_log");
            return fence == null || stripped == null ? null : new WoodPostBlock(m, fence, this.shortenedId() + "/" + w.getNamespace() + "/stripped_", fence.m_49962_(fence.m_49966_()) == SoundType.f_56763_);
        }).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(this.modRes("posts"), Registry.f_122901_)).setTab(() -> CreativeModeTab.f_40750_)).addRecipe(this.modRes("building/crafting/stripped_oak_post"))).setRenderType(() -> RenderType::m_110463_).build();
        this.addEntry(this.strippedPosts);
        this.verticalPlanks = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "planks", "vertical", VerticalPlanksModule.class, () -> this.getModBlock("vertical_oak_planks"), () -> WoodTypeRegistry.OAK_TYPE, (w, m) -> {
            String name = this.shortenedId() + "/" + w.getVariantId("planks", "vertical");
            return new QuarkBlock(name, m, CreativeModeTab.f_40749_, Utils.copyPropertySafe((BlockBehaviour)w.planks));
        }).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(BlockTags.f_13090_, Registry.f_122901_)).addTag(ItemTags.f_13168_, Registry.f_122904_)).addRecipe(this.modRes("building/crafting/vertplanks/vertical_oak_planks"))).build();
        this.addEntry(this.verticalPlanks);
        this.ladders = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "ladder", VariantLaddersModule.class, () -> this.getModBlock("spruce_ladder"), () -> WoodTypeRegistry.getValue((ResourceLocation)new ResourceLocation("spruce")), (w, m) -> {
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new VariantLadderBlock(name, m, w.canBurn());
        }).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_13082_, Registry.f_122901_)).addTag(this.modRes("ladders"), Registry.f_122901_)).addTag(this.modRes("ladders"), Registry.f_122904_)).addRecipe(this.modRes("building/crafting/spruce_ladder"))).addTexture(EveryCompat.res("block/spruce_ladder"))).setRenderType(() -> RenderType::m_110466_).build();
        this.addEntry(this.ladders);
        this.hollowLogs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "log", "hollow", HollowLogsModule.class, () -> this.getModBlock("hollow_oak_log"), () -> WoodTypeRegistry.OAK_TYPE, (w, m) -> {
            boolean whistlecane;
            boolean bl = whistlecane = w.getNamespace().equals("gardens_of_the_dead") && w.getTypeName().equals("whistlecane");
            if (w.getBlockOfThis("stripped_log") == null && !whistlecane) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new HollowLogBlock(name, w.log, m, w.canBurn());
        }).setTab(() -> CreativeModeTab.f_40749_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(this.modRes("hollow_logs"), Registry.f_122901_)).addTag(this.modRes("hollow_logs"), Registry.f_122904_)).addRecipe(this.modRes("building/crafting/hollowlogs/hollow_oak_log"))).addModelTransform(m -> m.addModifier((s, resLoc, w) -> {
            String namespace = w.getNamespace();
            String typeName = w.getTypeName();
            if (namespace.equals("gardens_of_the_dead") && typeName.equals("whistlecane")) {
                return s.replace("\"minecraft:block/stripped_oak_log\"", "\"gardens_of_the_dead:block/whistlecane_block\"");
            }
            return s;
        }))).build();
        this.addEntry(this.hollowLogs);
        this.chests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "chest", VariantChestsModule.class, () -> this.getModBlock("oak_chest", VariantChestBlock.class), () -> WoodTypeRegistry.OAK_TYPE, (w, m) -> {
            if (w.getId().toString().equals("twilightforest:dark")) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new CompatChestBlock((WoodType)w, name, (vazkii.quark.base.module.QuarkModule)m, Utils.copyPropertySafe((BlockBehaviour)w.planks));
        }).setTab(() -> CreativeModeTab.f_40749_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122901_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122904_)).addTag(this.modRes("revertable_chests"), Registry.f_122904_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(new ResourceLocation("quark:revertable_chests"), Registry.f_122904_)).addTile(CompatChestBlockTile::new).addCustomItem((w, b, p) -> new VariantChestBlock.Item((Block)b, p)).addRecipe(this.modRes("building/crafting/chests/oak_chest"))).build();
        this.addEntry(this.chests);
        this.trappedChests = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(WoodType.class, "trapped_chest", VariantChestsModule.class, () -> this.getModBlock("oak_trapped_chest", VariantTrappedChestBlock.class), () -> WoodTypeRegistry.OAK_TYPE, (w, m) -> {
            if (!this.chests.blocks.containsKey(w)) {
                return null;
            }
            String name = this.shortenedId() + "/" + w.getAppendableId();
            return new CompatTrappedChestBlock((WoodType)w, name, (vazkii.quark.base.module.QuarkModule)m, Utils.copyPropertySafe((BlockBehaviour)w.planks));
        }).addCustomItem((TriFunction<WoodType, VariantTrappedChestBlock, Item.Properties, Item>)((TriFunction)(w, b, p) -> new CompatChestBlock.Item((Block)b, (Item.Properties)p))).setTab(() -> CreativeModeTab.f_40749_)).addTag(Tags.Blocks.CHESTS_TRAPPED, Registry.f_122901_)).addTag(Tags.Blocks.CHESTS_TRAPPED, Registry.f_122904_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122904_)).addTag(Tags.Blocks.CHESTS_WOODEN, Registry.f_122901_)).addTag(this.modRes("revertable_trapped_chests"), Registry.f_122904_)).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTile(CompatTrappedChestBlockTile::new).addRecipe(this.modRes("building/crafting/chests/oak_trapped_chest"))).build();
        this.addEntry(this.trappedChests);
        this.hedges = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "hedge", HedgesModule.class, () -> this.getModBlock("oak_hedge"), () -> LeavesTypeRegistry.OAK_TYPE, (w, m) -> {
            if (w.getWoodType() == null) {
                return null;
            }
            return new HedgeBlock(m, Blocks.f_50132_, w.leaves);
        }).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(this.modRes("hedges"), Registry.f_122901_)).addTag(this.modRes("hedges"), Registry.f_122904_)).setTab(() -> CreativeModeTab.f_40749_)).addRecipe(this.modRes("building/crafting/oak_hedge"))).setRenderType(() -> RenderType::m_110463_).build();
        this.addEntry(this.hedges);
        this.leafCarpets = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)QuarkSimpleEntrySet.builder(LeavesType.class, "leaf_carpet", LeafCarpetModule.class, () -> this.getModBlock("oak_leaf_carpet"), () -> LeavesTypeRegistry.OAK_TYPE, (w, m) -> {
            String name = this.shortenedId() + "/" + w.getVariantId("%s_leaf_carpet");
            return new LeafCarpetBlock(name, w.leaves, m);
        }).addTag(this.modRes("leaf_carpets"), Registry.f_122901_)).addTag(this.modRes("leaf_carpets"), Registry.f_122904_)).setTab(() -> CreativeModeTab.f_40750_)).addRecipe(this.modRes("building/crafting/oak_leaf_carpet"))).setRenderType(() -> RenderType::m_110463_).build();
        this.addEntry(this.leafCarpets);
    }

    @Override
    public void onModSetup() {
        this.posts.blocks.forEach((w, post) -> {
            Block stripped = (Block)this.strippedPosts.blocks.get(w);
            if (stripped != null) {
                ToolInteractionHandler.registerInteraction((ToolAction)ToolActions.AXE_STRIP, (Block)post, (Block)stripped);
            }
        });
        this.leafCarpets.blocks.forEach((w, leaf) -> ComposterBlock.f_51914_.put(leaf, 0.2f));
    }

    @Override
    public void registerWoodBlocks(Registrator<Block> registry, Collection<WoodType> woodTypes) {
        try {
            Map data = (Map)this.ARLModData.get(null);
            super.registerWoodBlocks(registry, woodTypes);
            data.remove("everycomp");
        }
        catch (IllegalAccessException e) {
            EveryCompat.LOGGER.error("Failed to onCommonSetup Wood Good Quark Module: {0}", (Throwable)e);
        }
    }

    @Override
    public void registerLeavesBlocks(Registrator<Block> registry, Collection<LeavesType> leavesTypes) {
        try {
            Map data = (Map)this.ARLModData.get(null);
            super.registerLeavesBlocks(registry, leavesTypes);
            data.remove("everycomp");
        }
        catch (IllegalAccessException e) {
            EveryCompat.LOGGER.error("Failed to onCommonSetup Wood Good Quark Module: {0}", (Throwable)e);
        }
    }

    @Override
    public void registerTiles(Registrator<BlockEntityType<?>> registry) {
        super.registerTiles(registry);
        chestTile = Objects.requireNonNull(this.chests.getTileHolder()).get();
        trappedChestTile = Objects.requireNonNull(this.trappedChests.getTileHolder()).get();
    }

    @Override
    public void registerBlockColors(ClientPlatformHelper.BlockColorEvent event) {
        String typeName;
        String namespace;
        Block b;
        LeavesType t;
        super.registerBlockColors(event);
        for (Map.Entry entry : this.hedges.blocks.entrySet()) {
            t = (LeavesType)entry.getKey();
            b = (Block)entry.getValue();
            namespace = t.getNamespace();
            typeName = t.getTypeName();
            if (namespace.equals("regions_unexplored") ? typeName.equals("flowering") : namespace.equals("blue_skies") && typeName.equals("cherry")) continue;
            event.register((bs, l, p, i) -> event.getColor(t.leaves.m_49966_(), l, p, i), new Block[]{b});
        }
        for (Map.Entry entry : this.leafCarpets.blocks.entrySet()) {
            t = (LeavesType)entry.getKey();
            b = (Block)entry.getValue();
            namespace = t.getNamespace();
            typeName = t.getTypeName();
            if (namespace.equals("regions_unexplored") ? typeName.equals("flowering") : namespace.equals("blue_skies") && typeName.equals("cherry")) continue;
            event.register((bs, l, p, i) -> event.getColor(t.leaves.m_49966_(), l, p, i), new Block[]{b});
        }
    }

    @Override
    public void registerItemColors(ClientPlatformHelper.ItemColorEvent event) {
        String typeName;
        String namespace;
        Block b;
        LeavesType t;
        for (Map.Entry entry : this.hedges.blocks.entrySet()) {
            t = (LeavesType)entry.getKey();
            b = (Block)entry.getValue();
            namespace = t.getNamespace();
            typeName = t.getTypeName();
            if (namespace.equals("regions_unexplored") ? typeName.equals("flowering") : namespace.equals("blue_skies") && typeName.equals("cherry")) continue;
            event.register((stack, tintIndex) -> event.getColor(new ItemStack((ItemLike)t.leaves), tintIndex), new ItemLike[]{b.m_5456_()});
        }
        for (Map.Entry entry : this.leafCarpets.blocks.entrySet()) {
            t = (LeavesType)entry.getKey();
            b = (Block)entry.getValue();
            namespace = t.getNamespace();
            typeName = t.getTypeName();
            if (namespace.equals("regions_unexplored") ? typeName.equals("flowering") : namespace.equals("blue_skies") && typeName.equals("cherry")) continue;
            event.register((stack, tintIndex) -> event.getColor(new ItemStack((ItemLike)t.leaves), tintIndex), new ItemLike[]{b.m_5456_()});
        }
    }

    @Override
    public void registerBlockEntityRenderers(ClientPlatformHelper.BlockEntityRendererEvent event) {
        super.registerBlockEntityRenderers(event);
        event.register(chestTile, VariantChestRenderer::new);
        event.register(trappedChestTile, VariantChestRenderer::new);
    }

    @Override
    public void onClientInit() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTextureStitch);
    }

    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)CHEST_SHEET)) {
            this.chests.blocks.values().forEach(c -> VariantChestRenderer.accept((TextureStitchEvent.Pre)event, (Block)c));
            this.trappedChests.blocks.values().forEach(c -> VariantChestRenderer.accept((TextureStitchEvent.Pre)event, (Block)c));
        }
    }

    private Pair<List<Palette>, AnimationMetadataSection> bookshelfPalette(BlockType w, ResourceManager m) {
        Pair pair;
        block8: {
            TextureImage plankTexture = TextureImage.open((ResourceManager)m, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)m, (Block)((WoodType)w).planks));
            try {
                List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                targetPalette.forEach(p -> {
                    PaletteColor l0 = p.getDarkest();
                    p.increaseDown();
                    p.increaseDown();
                    p.increaseDown();
                    p.increaseDown();
                    p.remove(l0);
                });
                pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                if (plankTexture == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (plankTexture != null) {
                        try {
                            plankTexture.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                }
            }
            plankTexture.close();
        }
        return pair;
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        this.trappedChests.blocks.forEach((wood, block) -> {
            CompatTrappedChestBlock b = (CompatTrappedChestBlock)((Object)block);
            ResourceLocation res = this.modRes(b.getChestTexturePath() + "normal");
            ResourceLocation trappedRes = this.modRes(b.getChestTexturePath() + "trap");
            CompatChestTexture.generateChestTexture(handler, manager, wood, (Block)b, res, trappedRes, this.modRes("model/chest/oak/normal"), EveryCompat.res("model/oak_chest_normal_m"), EveryCompat.res("model/oak_chest_normal_o"), EveryCompat.res("model/trapped_chest_normal"));
            res = this.modRes(b.getChestTexturePath() + "left");
            if (!handler.alreadyHasTextureAtLocation(manager, res)) {
                trappedRes = this.modRes(b.getChestTexturePath() + "trap_left");
                CompatChestTexture.generateChestTexture(handler, manager, wood, (Block)b, res, trappedRes, this.modRes("model/chest/oak/left"), EveryCompat.res("model/oak_chest_left_m"), EveryCompat.res("model/oak_chest_left_o"), EveryCompat.res("model/trapped_chest_left"));
            }
            if (!handler.alreadyHasTextureAtLocation(manager, res = this.modRes(b.getChestTexturePath() + "right"))) {
                trappedRes = this.modRes(b.getChestTexturePath() + "trap_right");
                CompatChestTexture.generateChestTexture(handler, manager, wood, (Block)b, res, trappedRes, this.modRes("model/chest/oak/right"), EveryCompat.res("model/oak_chest_right_m"), EveryCompat.res("model/oak_chest_right_o"), EveryCompat.res("model/trapped_chest_right"));
            }
        });
    }

    static {
        CHEST_SHEET = new ResourceLocation("textures/atlas/chest.png");
    }
}

