/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.forge.regions_unexplored;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.SpriteHelper;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.plant.other.BranchBlock;
import net.regions_unexplored.world.level.block.plant.tall.ShrubBlock;

public class RegionsUnexploredModule
extends SimpleModule {
    public final SimpleEntrySet<WoodType, Block> branchs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(WoodType.class, "branch", () -> this.getModBlock("oak_branch"), () -> WoodTypeRegistry.OAK_TYPE, w -> new BranchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)RuBlocks.ACACIA_BRANCH.get())))).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(this.modRes("branches_can_survive_on"), Registry.f_122901_)).addTag(this.modRes("branches"), Registry.f_122901_)).addTag(this.modRes("branches"), Registry.f_122904_)).addRecipe(this.modRes("oak_branch_from_oak_log"))).setRenderType(() -> RenderType::m_110463_).build();
    public final SimpleEntrySet<LeavesType, Block> shrubs;

    public RegionsUnexploredModule(String modId) {
        super(modId, "ru");
        this.addEntry(this.branchs);
        this.shrubs = ((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)((SimpleEntrySet.Builder)SimpleEntrySet.builder(LeavesType.class, "shrub", () -> this.getModBlock("dark_oak_shrub"), () -> LeavesTypeRegistry.getValue((ResourceLocation)new ResourceLocation("dark_oak")), l -> {
            EveryCompat.LOGGER.warn("CHECK: {}", (Object)l.getBlockOfThis("sapling"));
            return new ShrubBlock(Utils.copyPropertySafe((BlockBehaviour)l.leaves).m_60910_().m_60966_().m_60918_(SoundType.f_154666_).m_222979_(BlockBehaviour.OffsetType.XZ));
        }).addCondition(l -> {
            boolean log = l.getWoodType().log != null;
            boolean leave = l.leaves != null;
            boolean sapling = l.getItemOfThis("sapling") != null;
            return log && leave && sapling;
        })).addTag(BlockTags.f_144280_, Registry.f_122901_)).addTag(this.modRes("shrubs"), Registry.f_122901_)).addTag(this.modRes("shrub_can_survive_on"), Registry.f_122901_)).addTag(this.modRes("shrubs"), Registry.f_122904_)).addTexture(EveryCompat.res("block/dark_oak_shrub_top"))).copyParentDrop().build();
        this.addEntry(this.shrubs);
    }

    @Override
    public void registerItemColors(ClientPlatformHelper.ItemColorEvent event) {
        super.registerItemColors(event);
        for (Map.Entry entry : this.shrubs.blocks.entrySet()) {
            LeavesType type = (LeavesType)entry.getKey();
            Block block = (Block)entry.getValue();
            event.register((stack, tintIndex) -> {
                if (tintIndex > 0) {
                    return -1;
                }
                return event.getColor(new ItemStack((ItemLike)type.leaves), tintIndex);
            }, new ItemLike[]{block});
        }
    }

    @Override
    public void registerBlockColors(ClientPlatformHelper.BlockColorEvent event) {
        super.registerBlockColors(event);
        for (Map.Entry entry : this.shrubs.blocks.entrySet()) {
            LeavesType type = (LeavesType)entry.getKey();
            Block b = (Block)entry.getValue();
            event.register((blockState, tintGetter, pos, index) -> event.getColor(type.leaves.m_49966_(), tintGetter, pos, index), new Block[]{b});
        }
    }

    @Override
    public void onModSetup() {
        this.branchs.blocks.forEach((woodType, block) -> ComposterBlock.f_51914_.put(block, 0.3f));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicServerResources(handler, manager);
        ResourceLocation shrubRecipe = this.modRes("dark_oak_shrub");
        ResourceLocation sapling_shrubRecipe = this.modRes("dark_oak_sapling_from_dark_oak_shrub");
        try (InputStream shrubStream = ((Resource)manager.m_213713_(ResType.RECIPES.getPath(shrubRecipe)).orElseThrow(() -> new FileNotFoundException("File not found: " + shrubRecipe))).m_215507_();
             InputStream sapling_shrubStream = ((Resource)manager.m_213713_(ResType.RECIPES.getPath(sapling_shrubRecipe)).orElseThrow(() -> new FileNotFoundException("File not found: " + sapling_shrubRecipe))).m_215507_();){
            JsonObject recipeShrub = RPUtils.deserializeJson((InputStream)shrubStream);
            JsonObject recipeSapling_shrub = RPUtils.deserializeJson((InputStream)sapling_shrubStream);
            this.shrubs.blocks.forEach((leavesType, block) -> {
                String saplingID = leavesType.getNamespace() + ":" + leavesType.getTypeName() + "_sapling";
                recipeShrub.getAsJsonObject("key").getAsJsonObject("#").addProperty("item", saplingID);
                recipeShrub.getAsJsonObject("result").addProperty("item", Utils.getID((Block)block).toString());
                recipeSapling_shrub.getAsJsonArray("ingredients").get(0).getAsJsonObject().addProperty("item", Utils.getID((Block)block).toString());
                recipeSapling_shrub.getAsJsonObject("result").addProperty("item", saplingID);
                String shrubName = leavesType.getTypeName() + "_shrub";
                ((DynamicDataPack)handler.dynamicPack).addJson(EveryCompat.res(this.shortenedId() + "/" + leavesType.getNamespace() + "/" + shrubName), (JsonElement)recipeShrub, ResType.RECIPES);
                ((DynamicDataPack)handler.dynamicPack).addJson(EveryCompat.res(this.shortenedId() + "/" + leavesType.getAppendableId() + "_sapling_from_" + shrubName), (JsonElement)recipeSapling_shrub, ResType.RECIPES);
            });
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to open the recipe: ", (Throwable)e);
        }
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        super.addDynamicClientResources(handler, manager);
        try (TextureImage branch_side = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("item/regions_unexplored/oak_branch_side"));
             TextureImage branch_top = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("item/regions_unexplored/oak_branch_top"));
             TextureImage branch_block = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/oak_branch"));){
            this.branchs.blocks.forEach((wood, block) -> {
                try (TextureImage logSide_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));
                     TextureImage logTop_texture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                    ResourceLocation resLocITEM = EveryCompat.res("item/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");
                    ResourceLocation resLocBLOCK = EveryCompat.res("block/" + this.shortenedId() + "/" + wood.getAppendableId() + "_branch");
                    Respriter respriterSIDE = Respriter.of((TextureImage)branch_side);
                    Respriter respriterTOP = Respriter.of((TextureImage)branch_top);
                    Respriter respriterBlock = Respriter.of((TextureImage)branch_block);
                    TextureImage recoloredITEM = respriterSIDE.recolorWithAnimationOf(logSide_texture);
                    TextureImage recoloredTOP = respriterTOP.recolorWithAnimationOf(logTop_texture);
                    recoloredITEM.applyOverlay(new TextureImage[]{recoloredTOP});
                    TextureImage recoloredBLOCK = respriterBlock.recolorWithAnimationOf(logSide_texture);
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(resLocBLOCK, recoloredBLOCK);
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(resLocITEM, recoloredITEM);
                }
                catch (IOException e) {
                    handler.getLogger().error("Failed to get Log Texture for {} : {}", block, (Object)e);
                }
            });
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to get Branch Item Texture for ", (Throwable)e);
        }
        try (TextureImage shrubMiddle = TextureImage.open((ResourceManager)manager, (ResourceLocation)EveryCompat.res("block/regions_unexplored/dark_oak_shrub_middle"));
             TextureImage shrubBottom = TextureImage.open((ResourceManager)manager, (ResourceLocation)this.modRes("block/dark_oak_shrub_bottom"));){
            this.shrubs.blocks.forEach((leavesType, block) -> {
                String shrubPath = this.shortenedId() + "/" + leavesType.getAppendableId() + "_shrub";
                String crossModel = "{\n    \"parent\": \"minecraft:block/cross\",\n    \"render_type\": \"cutout\",\n    \"textures\": {\n        \"particle\": \"[shrub_top]\",\n        \"cross_tint\": \"[shrub_top]\",\n        \"cross\": \"[shrub_middle]\"\n    },\n    \"elements\": [\n        {   \"from\": [ 0.8, 0, 8 ],\n            \"to\": [ 15.2, 16, 8 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"north\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" },\n                \"south\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" }\n            }\n        },\n        {   \"from\": [ 8, 0, 0.8 ],\n            \"to\": [ 8, 16, 15.2 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"west\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" },\n                \"east\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross\" }\n            }\n        },\n        {   \"from\": [ 0.8, 0, 8 ],\n            \"to\": [ 15.2, 16, 8 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"north\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 },\n                \"south\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 }\n            }\n        },\n        {   \"from\": [ 8, 0, 0.8 ],\n            \"to\": [ 8, 16, 15.2 ],\n            \"rotation\": { \"origin\": [ 8, 8, 8 ], \"axis\": \"y\", \"angle\": 45, \"rescale\": true },\n            \"shade\": false,\n            \"faces\": {\n                \"west\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 },\n                \"east\": { \"uv\": [ 0, 0, 16, 16 ], \"texture\": \"#cross_tint\", \"tintindex\": 0 }\n            }\n        }\n    ]\n}\n";
                String blockID = "everycomp:block/" + shrubPath;
                String newModel = crossModel.replace("[shrub_middle]", blockID + "_middle").replace("[shrub_top]", blockID + "_top");
                ((DynamicTexturePack)handler.dynamicPack).addBytes(EveryCompat.res(shrubPath), newModel.getBytes(), ResType.BLOCK_MODELS);
                ResourceLocation itemPath = ResType.ITEM_MODELS.getPath(EveryCompat.res(shrubPath));
                try (InputStream modelItemStream = ((Resource)manager.m_213713_(itemPath).orElseThrow(FileNotFoundException::new)).m_215507_();){
                    JsonObject modelItem = RPUtils.deserializeJson((InputStream)modelItemStream);
                    modelItem.getAsJsonObject("textures").addProperty("layer0", blockID + "_top");
                    modelItem.getAsJsonObject("textures").addProperty("layer1", blockID + "_middle");
                    ((DynamicTexturePack)handler.dynamicPack).addJson(EveryCompat.res(shrubPath), (JsonElement)modelItem, ResType.ITEM_MODELS);
                }
                catch (IOException e) {
                    handler.getLogger().error("Failed to open the item model file via {} : {}", (Object)itemPath, (Object)e);
                }
                try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)leavesType.getWoodType().log, SpriteHelper.LOOKS_LIKE_SIDE_LOG_TEXTURE));){
                    Respriter respriterBottom = Respriter.of((TextureImage)shrubBottom);
                    Respriter respriterMiddle = Respriter.of((TextureImage)shrubMiddle);
                    TextureImage recoloredMiddle = respriterMiddle.recolorWithAnimationOf(logTexture);
                    TextureImage recoloredBottom = respriterBottom.recolorWithAnimationOf(logTexture);
                    String resLoc = "block/" + shrubPath;
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(resLoc + "_middle"), recoloredMiddle);
                    ((DynamicTexturePack)handler.dynamicPack).addAndCloseTexture(EveryCompat.res(resLoc + "_bottom"), recoloredBottom);
                }
                catch (IOException e) {
                    handler.getLogger().error("Failed to get texture for {} : {}", (Object)block.toString(), (Object)e);
                }
            });
        }
        catch (IOException e) {
            handler.getLogger().error("Failed to open textures for: ", (Throwable)e);
        }
    }
}

