package net.mehvahdjukaar.every_compat.modules.architect_palette;

import architectspalette.content.blocks.RailingBlock;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.PaletteStrategies;
import net.mehvahdjukaar.every_compat.api.PaletteStrategy;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_7924;

import static net.mehvahdjukaar.every_compat.api.PaletteStrategies.registerCached;
import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.PLANKS;

//SUPPORT: v1.4.0-Beta.5+
public class ArchitectsPaletteModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> railings;
    public final SimpleEntrySet<WoodType, class_2248> boards;
    public final SimpleEntrySet<WoodType, class_2248> boardSlabs;
    public final SimpleEntrySet<WoodType, class_2248> boardStairs;
    public final SimpleEntrySet<WoodType, class_2248> boardWalls;

    public ArchitectsPaletteModule(String modId) {
        super(modId, "ap", EveryCompat.MOD_ID);
        class_2960 tab = modRes("architects_palette");

        railings = SimpleEntrySet.builder(WoodType.class, "railing",
                        getModBlock("oak_railing"), () -> VanillaWoodTypes.OAK,
                        w -> new RailingBlock(Utils.copyPropertySafe(w.planks))
                )
                //TEXTURES: planks
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(railings);

        boards = SimpleEntrySet.builder(WoodType.class, "boards",
                        getModBlock("oak_boards"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2248(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/oak_boards"), customPalette)
                .addTexture(modRes("block/oak_boards_odd"), customPalette)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(boards);

        boardSlabs = SimpleEntrySet.builder(WoodType.class, "board_slab",
                        getModBlock("oak_board_slab"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2482(Utils.copyPropertySafe(w.planks))
                )
                .requiresFromMap(boards.blocks) //REASONS: textures, recipes
                //TEXTURES: boards
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15469, class_7924.field_41254)
                .addTag(class_3489.field_15535, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .copyParentDrop()
                .build();
        this.addEntry(boardSlabs);

        boardStairs = SimpleEntrySet.builder(WoodType.class, "board_stairs",
                        getModBlock("oak_board_stairs"), () -> VanillaWoodTypes.OAK,
                        w -> new ModStairBlock(() -> boards.blocks.get(w), Utils.copyPropertySafe(w.planks))
                )
                .requiresFromMap(boards.blocks) //REASONS: textures, recipes
                //TEXTURES: boards
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15459, class_7924.field_41254)
                .addTag(class_3489.field_15526, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(boardStairs);

        boardWalls = SimpleEntrySet.builder(WoodType.class, "board_wall",
                        getModBlock("oak_board_wall"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2544(Utils.copyPropertySafe(w.planks))
                )
                .requiresFromMap(boards.blocks) //REASONS: textures, recipes
                //TEXTURES: boards
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .addTag(class_3489.field_15560, class_7924.field_41197)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(boardWalls);

    }

    public static final PaletteStrategy customPalette = registerCached((blockType, manager) -> PaletteStrategies.makePaletteFromChild(
            blockType, manager, PLANKS, null, p -> {

                while (p.size() > 7) {
                    p.remove(p.getDarkest());
                }

                var col = p.getColorAtSlope(0.5f);
                int ind = p.indexOf(col);
                var lab = col.lab();
                PaletteColor newC = new PaletteColor(lab.withLuminance(lab.luminance() * 1.03f));
                float dl = p.get(ind + 1).luminance() - newC.luminance();
                p.set(ind, newC);
                PaletteColor before = p.get(ind - 1);
                //lighten the other main plank mask if its too dark
                if (newC.luminance() - before.luminance() > dl * 1.5) {
                    PaletteColor newBefore = new PaletteColor(before.lab().withLuminance(
                            (before.luminance() * 0.6f + (newC.luminance() + dl) * 0.4f)));
                    p.set(ind - 1, newBefore);
                }

            })
    );

}
