package net.mehvahdjukaar.every_compat.modules.mrcrayfish;

import com.mrcrayfish.furniture.refurbished.block.*;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.CeilingFanBlockEntityRenderer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.item.MailboxItem;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.CompatSpritesHelper;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2498;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

//SUPPORT: v1.0.12+
public class RefurbishedFurnitureModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> chairs;
    public final SimpleEntrySet<WoodType, class_2248> tables;
    public final SimpleEntrySet<WoodType, class_2248> darkFans;
    public final SimpleEntrySet<WoodType, class_2248> lightFans;
    public final SimpleEntrySet<WoodType, class_2248> toilets;
    public final SimpleEntrySet<WoodType, class_2248> crates;
    public final SimpleEntrySet<WoodType, class_2248> mailboxes;
    public final SimpleEntrySet<WoodType, class_2248> jars;
    public final SimpleEntrySet<WoodType, class_2248> kitchen_cabinetry;
    public final SimpleEntrySet<WoodType, class_2248> kitchen_drawer;
    public final SimpleEntrySet<WoodType, class_2248> kitchen_sink;
    public final SimpleEntrySet<WoodType, class_2248> kitchen_storage_cabinet;
    public final SimpleEntrySet<WoodType, class_2248> storage_cabinet;
    public final SimpleEntrySet<WoodType, class_2248> basin;
    public final SimpleEntrySet<WoodType, class_2248> bath;
    public final SimpleEntrySet<WoodType, class_2248> lattice_fence;
    public final SimpleEntrySet<WoodType, class_2248> lattice_fence_gate;
    public final SimpleEntrySet<WoodType, class_2248> desk;
    public final SimpleEntrySet<WoodType, class_2248> cutting_board;
    public final SimpleEntrySet<WoodType, class_2248> drawer;
    public final SimpleEntrySet<LeavesType, class_2248> hedges;


    public RefurbishedFurnitureModule(String modId) {
        super(modId, "rfm", EveryCompat.MOD_ID);
        class_2960 tab = modRes("creative_tab");

        chairs = SimpleEntrySet.builder(WoodType.class, "chair",
                        getModBlock("oak_chair"), () -> VanillaWoodTypes.OAK,
                        w -> new ChairBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637().method_9632(2.0F))))
                .addRecipe(modRes("constructing/oak_chair"))
                .setTabKey(tab)
                .addTexture(modRes("block/oak_chair"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("general"), class_7924.field_41197)
                .build();
        this.addEntry(chairs);

        tables = SimpleEntrySet.builder(WoodType.class, "table",
                        getModBlock("oak_table"), () -> VanillaWoodTypes.OAK,
                        w -> new TableBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637()
                                .method_9632(2.0F))))
                .addRecipe(modRes("constructing/oak_table"))
                .setTabKey(tab)
                .addTexture(modRes("block/oak_table"))
                .addTexture(modRes("block/oak_particle"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("tuckable"), class_7924.field_41254)
                .addTag(modRes("general"), class_7924.field_41197)
                .build();
        this.addEntry(tables);

        darkFans = SimpleEntrySet.builder(WoodType.class, "dark_ceiling_fan",
                        getModBlock("oak_dark_ceiling_fan"), () -> VanillaWoodTypes.OAK,
                        w -> new CeilingFanBlock(w.toVanillaOrOak(),
                                MetalType.DARK,
                                class_4970.class_2251.method_9637().method_31710(w.planks.method_26403())
                                        .method_9632(0.8F).method_9626(w.getSound()).method_9631(CeilingFanBlock::light)))
                .defaultRecipe()
                .addRecipe(modRes("constructing/oak_dark_ceiling_fan"))
                .addTile(ModBlockEntities.CEILING_FAN::get)
                .setTabKey(tab)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("electronics"), class_7924.field_41197)
                .addTag(modRes("bedroom"), class_7924.field_41197)
                .addTextureM(modRes("block/oak_dark_ceiling_fan"),
                        EveryCompat.res("block/rfm/oak_ceiling_fan_m"))
                .setRenderType(RenderLayer.TRANSLUCENT)
                .build();
        this.addEntry(darkFans);

        lightFans = SimpleEntrySet.builder(WoodType.class, "light_ceiling_fan",
                        getModBlock("oak_light_ceiling_fan"), () -> VanillaWoodTypes.OAK,
                        w -> new CeilingFanBlock(w.toVanillaOrOak(),
                                MetalType.DARK,
                                class_4970.class_2251.method_9637().method_31710(w.planks.method_26403())
                                        .method_9632(0.8F).method_9626(w.getSound()).method_9631(CeilingFanBlock::light)))
                .addRecipe(modRes("constructing/oak_light_ceiling_fan"))
                .addTile(ModBlockEntities.CEILING_FAN::get)
                .setTabKey(tab)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("electronics"), class_7924.field_41197)
                .addTag(modRes("bedroom"), class_7924.field_41197)
                .addTextureM(modRes("block/oak_light_ceiling_fan"),
                        EveryCompat.res("block/rfm/oak_ceiling_fan_m"))
                .setRenderType(RenderLayer.TRANSLUCENT)
                .build();
        this.addEntry(lightFans);


        crates = SimpleEntrySet.builder(WoodType.class, "crate",
                        getModBlock("oak_crate"), () -> VanillaWoodTypes.OAK,
                        w -> new CrateBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637()
                                .method_51369().method_9632(2.5F))))
                .addRecipe(modRes("constructing/oak_crate"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.CRATE::get)
                .addTexture(modRes("block/oak_crate"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("storage"), class_7924.field_41197)
                .addTag(modRes("outdoors"), class_7924.field_41197)
                .build();
        this.addEntry(crates);

        mailboxes = SimpleEntrySet.builder(WoodType.class, "mail_box",
                        getModBlock("oak_mail_box"), () -> VanillaWoodTypes.OAK,
                        w -> new MailboxBlock(w.toVanillaOrOak(), addWoodPropNoFire(w, class_4970.class_2251.method_9637()
                                .method_9632(2.5F))))
                .addRecipe(modRes("constructing/oak_mail_box"))
                .addCustomItem((woodType, block, properties) -> new MailboxItem(block, properties))
                .setTabKey(tab)
                .addTile(ModBlockEntities.MAIL_BOX::get)
                .addTextureM(modRes("block/oak_mail_box"),
                        EveryCompat.res("block/rfm/oak_mail_box_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("outdoors"), class_7924.field_41197)
                .addTag(modRes("storage"), class_7924.field_41197)
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(mailboxes);

        toilets = SimpleEntrySet.builder(WoodType.class, "toilet",
                        getModBlock("oak_toilet"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenToiletBlock(w.toVanillaOrOak(), class_4970.class_2251.method_9637().method_31710(w.planks.method_26403())
                                .method_9632(3.5f).method_9626(class_2498.field_11544)))
                .addRecipe(modRes("constructing/oak_toilet"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.TOILET::get)
                .addTextureM(modRes("block/oak_toilet"),
                        EveryCompat.res("block/rfm/oak_toilet_m"))
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("wooden_toilets"), class_7924.field_41197)
                .addTag(modRes("bathroom"), class_7924.field_41197)
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(toilets);

        jars = SimpleEntrySet.builder(WoodType.class, "storage_jar",
                        getModBlock("oak_storage_jar"), () -> VanillaWoodTypes.OAK,
                        w -> new StorageJarBlock(w.toVanillaOrOak(), class_4970.class_2251.method_9637()
                                .method_31710(w.planks.method_26403())
                                .method_51368(class_2766.field_12645).method_9632(1.0F).method_9626(class_2498.field_11537)))
                .addRecipe(modRes("constructing/oak_storage_jar"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_JAR::get)
                .addTextureM(modRes("block/oak_storage_jar"),
                        EveryCompat.res("block/rfm/oak_storage_jar_m"))
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("storage"), class_7924.field_41197)
                .addTag(modRes("kitchen"), class_7924.field_41197)
                .setRenderType(RenderLayer.CUTOUT)
                .build();
        this.addEntry(jars);

        kitchen_cabinetry = SimpleEntrySet.builder(WoodType.class, "kitchen_cabinetry",
                        getModBlock("oak_kitchen_cabinetry"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenCabinetryBlock(w.toVanillaOrOak(),
                                addWoodProp(w, class_4970.class_2251.method_9637()).method_51369().method_9632(2.0f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_cabinetry"))
                .setTabKey(tab)
//                .addTile(ModBlockEntities.STORAGE_CABINET::get)
                .addTextureM(modRes("block/oak_kitchen_cabinetry"),
                        EveryCompat.res("block/rfm/oak_kitchen_cabinetry_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_kitchen_cabinetry"), class_7924.field_41197)
                .addTag(modRes("kitchen"), class_7924.field_41197)
                .build();
        this.addEntry(kitchen_cabinetry);

        kitchen_drawer = SimpleEntrySet.builder(WoodType.class, "kitchen_drawer",
                        getModBlock("oak_kitchen_drawer"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenDrawerBlock(w.toVanillaOrOak(),
                                addWoodProp(w, class_4970.class_2251.method_9637()).method_51369().method_9632(2.5f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_drawer"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.KITCHEN_DRAWER::get)
                .addTextureM(modRes("block/oak_kitchen_drawer"),
                        EveryCompat.res("block/rfm/oak_kitchen_drawer_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("storage"), class_7924.field_41197)
                .addTag(modRes("kitchen"), class_7924.field_41197)
                .addTag(modRes("wooden_kitchen_drawers"), class_7924.field_41197)
                .build();
        this.addEntry(kitchen_drawer);

        kitchen_sink = SimpleEntrySet.builder(WoodType.class, "kitchen_sink",
                        getModBlock("oak_kitchen_sink"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenSinkBlock(w.toVanillaOrOak(),
                                addWoodProp(w, class_4970.class_2251.method_9637()).method_51369().method_9632(2.5f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_sink"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.KITCHEN_SINK::get)
                .addTextureM(modRes("block/oak_kitchen_sink"),
                        EveryCompat.res("block/rfm/oak_kitchen_sink_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_kitchen_sinks"), class_7924.field_41197)
                .addTag(modRes("kitchen"), class_7924.field_41197)
                .addTag(modRes("storage"), class_7924.field_41197)
                .build();
        this.addEntry(kitchen_sink);

        kitchen_storage_cabinet = SimpleEntrySet.builder(WoodType.class, "kitchen_storage_cabinet",
                        getModBlock("oak_kitchen_storage_cabinet"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenKitchenStorageCabinetBlock(w.toVanillaOrOak(),
                                addWoodProp(w, class_4970.class_2251.method_9637()).method_51369().method_9632(2.5f))
                )
                .addRecipe(modRes("constructing/oak_kitchen_storage_cabinet"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_CABINET::get)
                .addTextureM(modRes("block/oak_kitchen_storage_cabinet"),
                        EveryCompat.res("block/rfm/oak_kitchen_storage_cabinet_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_kitchen_storage_cabinets"), class_7924.field_41197)
                .addTag(modRes("kitchen"), class_7924.field_41197)
                .addTag(modRes("storage"), class_7924.field_41197)
                .build();
        this.addEntry(kitchen_storage_cabinet);

        storage_cabinet = SimpleEntrySet.builder(WoodType.class, "storage_cabinet",
                        getModBlock("oak_storage_cabinet"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenStorageCabinetBlock(w.toVanillaOrOak(),
                                addWoodProp(w, class_4970.class_2251.method_9637()).method_51369().method_9632(2.5f))
                )
                .addRecipe(modRes("constructing/oak_storage_cabinet"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_CABINET::get)
                .addTextureM(modRes("block/oak_storage_cabinet"),
                        EveryCompat.res("block/rfm/oak_storage_cabinet_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("general"), class_7924.field_41197)
                .addTag(modRes("bedroom"), class_7924.field_41197)
                .addTag(modRes("kitchen"), class_7924.field_41197)
                .addTag(modRes("storage"), class_7924.field_41197)
                .build();
        this.addEntry(storage_cabinet);

        basin = SimpleEntrySet.builder(WoodType.class, "basin",
                        getModBlock("oak_basin"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenBasinBlock(w.toVanillaOrOak(), class_4970.class_2251.method_9637()
                                .method_31710(w.planks.method_26403())
                                .method_9632(3.5f).method_9626(class_2498.field_11544)
                        )
                )
                .addRecipe(modRes("constructing/oak_basin"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.BASIN::get)
                .addTextureM(modRes("block/oak_basin"),
                        EveryCompat.res("block/rfm/oak_basin_m"))
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("wooden_basins"), class_7924.field_41197)
                .addTag(modRes("bathroom"), class_7924.field_41197)
                .build();
        this.addEntry(basin);

        bath = SimpleEntrySet.builder(WoodType.class, "bath",
                        getModBlock("oak_bath"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenBathBlock(w.toVanillaOrOak(), class_4970.class_2251.method_9637()
                                .method_31710(w.planks.method_26403())
                                .method_9632(3.5f).method_9626(class_2498.field_11544)
                        )
                )
                .addRecipe(modRes("constructing/oak_bath"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.BATH::get)
                .addTextureM(modRes("block/oak_bath"),
                        EveryCompat.res("block/rfm/oak_bath_m"))
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(modRes("bathroom"), class_7924.field_41197)
                .addTag(modRes("wooden_baths"), class_7924.field_41197)
                .build();
        this.addEntry(bath);

        lattice_fence = SimpleEntrySet.builder(WoodType.class, "lattice_fence",
                        getModBlock("oak_lattice_fence"), () -> VanillaWoodTypes.OAK,
                        w -> new LatticeFenceBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637()
                                .method_9632(2.0f).method_51369())
                        )
                )
                .addRecipe(modRes("constructing/oak_lattice_fence"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_JAR::get)
                .addTexture(modRes("block/oak_lattice_fence"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_16584, class_7924.field_41254)
                .addTag(class_3481.field_17619, class_7924.field_41254)
                .addTag(modRes("outdoors"), class_7924.field_41197)
                .addTag(class_3481.field_16584, class_7924.field_41197)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(lattice_fence);

        lattice_fence_gate = SimpleEntrySet.builder(WoodType.class, "lattice_fence_gate",
                        getModBlock("oak_lattice_fence_gate"), () -> VanillaWoodTypes.OAK,
                        w -> new LatticeFenceGateBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637())
                                .method_9632(2.0f)
                        )
                )
                .addRecipe(modRes("constructing/oak_lattice_fence_gate"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.STORAGE_JAR::get)
                .addTextureM(modRes("block/oak_lattice_fence_gate"),
                        EveryCompat.res("block/rfm/oak_lattice_fence_gate_m"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_25147, class_7924.field_41254)
                .addTag(class_3481.field_25148, class_7924.field_41254)
                .addTag(modRes("outdoors"), class_7924.field_41197)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .build();
        this.addEntry(lattice_fence_gate);

        desk = SimpleEntrySet.builder(WoodType.class, "desk",
                        getModBlock("oak_desk"), () -> VanillaWoodTypes.OAK,
                        w -> new DeskBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637())
                                .method_9632(2.0f).method_51369()
                        )
                )
                .addTexture(modRes("block/oak_desk"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("tuckable"), class_7924.field_41254)
                .addTag(modRes("general"), class_7924.field_41197)
                .addTag(modRes("bedroom"), class_7924.field_41197)
                .setTabKey(tab)
                .addRecipe(modRes("constructing/oak_desk"))
                .build();
        this.addEntry(desk);

        cutting_board = SimpleEntrySet.builder(WoodType.class, "cutting_board",
                        getModBlock("oak_cutting_board"), () -> VanillaWoodTypes.OAK,
                        w -> new CuttingBoardBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637())
                                .method_9632(1.5f)
                        )
                )
                .addRecipe(modRes("constructing/oak_cutting_board"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.CUTTING_BOARD::get)
                .addTexture(modRes("block/oak_cutting_board"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("kitchen"), class_7924.field_41197)
                .build();
        this.addEntry(cutting_board);

        drawer = SimpleEntrySet.builder(WoodType.class, "drawer",
                        getModBlock("oak_drawer"), () -> VanillaWoodTypes.OAK,
                        w -> new DrawerBlock(w.toVanillaOrOak(), addWoodProp(w, class_4970.class_2251.method_9637())
                                .method_9632(2.5f).method_51369()
                        )
                )
                .addTile(ModBlockEntities.DRAWER::get)
                .addTexture(modRes("block/oak_drawer"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("storage"), class_7924.field_41197)
                .addTag(modRes("bedroom"), class_7924.field_41197)
                .addTag(modRes("general"), class_7924.field_41197)
                .setTabKey(tab)
                .addRecipe(modRes("constructing/oak_drawer"))
                .build();
        this.addEntry(drawer);

        hedges = SimpleEntrySet.builder(LeavesType.class, "hedge",
                        getModBlock("oak_hedge"), () -> VanillaLeavesTypes.OAK,
                        l -> new HedgeBlock(LeafType.OAK, class_4970.class_2251.method_9637().method_9632(0.5f)
                                .method_9626(class_2498.field_28702))
                )
                .requiresChildren("leaves") // Textures
                .addModelTransform(m -> m.replaceWithTextureFromChild("minecraft:block/oak_leaves",
                        "leaves", CompatSpritesHelper.LOOKS_LIKE_LEAF_TEXTURE))
                .addRecipe(modRes("constructing/oak_hedge"))
                .setTabKey(tab)
                .addTile(ModBlockEntities.DRAWER::get)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .copyParentTint()
                .build();
        this.addEntry(hedges);
    }

    @Override
    // MODELS
    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);

        executor.accept((manager, sink) -> {

            // code copied from ResourceUtils.addStandardResources
            StaticResource darkBlade = StaticResource.getOrLog(manager, ResType.MODELS.getPath(
                    modRes("extra/oak_dark_ceiling_fan_blade")
            ));
            addFanModels(sink, manager, darkBlade, darkFans);
            StaticResource lightBlade = StaticResource.getOrLog(manager, ResType.MODELS.getPath(
                    modRes("extra/oak_light_ceiling_fan_blade")
            ));
            addFanModels(sink, manager, lightBlade, lightFans);
        });
    }

    private void addFanModels(ResourceSink sink, class_3300 manager, StaticResource darkBlade, SimpleEntrySet<WoodType, class_2248> darkFans) {
        darkFans.blocks.forEach((w, b) -> {
            try {
                sink.addSimilarJsonResource(manager, darkBlade, s ->
                        s.replace("oak", w.getAppendableId())
                                .replace("texture\": \"refurbished_furniture:block", "texture\": \"everycomp:block/rfm"));

            } catch (Exception exception) {
                EveryCompat.LOGGER.error("Failed to add {} model json file:", b, exception);
            }
        });
    }

    @Override
    public void onClientSetup() {
        super.onClientSetup();
        darkFans.blocks.forEach((key, value) -> {
            class_2960 res = EveryCompat.res("extra/" + key.getAppendableId() + "_dark_ceiling_fan_blade");
            CeilingFanBlockEntityRenderer.registerFanBlade(value, () ->
                    ClientHelper.getModel(class_310.method_1551().method_1554(),
                            RenderUtil.getStandaloneModelLocation(res)));
        });
        lightFans.blocks.forEach((key, value) -> {
            class_2960 res = EveryCompat.res("extra/" + key.getAppendableId() + "_light_ceiling_fan_blade");
            CeilingFanBlockEntityRenderer.registerFanBlade(value, () ->
                    ClientHelper.getModel(class_310.method_1551().method_1554(),
                            RenderUtil.getStandaloneModelLocation(res)));
        });
    }

    @Override
    public void onClientInit() {
        super.onClientInit();
        ClientHelper.addSpecialModelRegistration(event -> darkFans.blocks.keySet().forEach(w -> {
            event.register(EveryCompat.res("extra/" + w.getAppendableId() + "_dark_ceiling_fan_blade"));
            event.register(EveryCompat.res("extra/" + w.getAppendableId() + "_light_ceiling_fan_blade"));
        }));
    }

    public static class_4970.class_2251 addWoodProp(WoodType w, class_4970.class_2251 p) {
        if (w.canBurn()) p.method_50013();
        p.method_31710(w.planks.method_26403()).method_9626(w.getSound()).method_51368(class_2766.field_12651);
        return p;
    }

    public static class_4970.class_2251 addWoodPropNoFire(WoodType w, class_4970.class_2251 p) {
        p.method_31710(w.planks.method_26403()).method_9626(w.getSound()).method_51368(class_2766.field_12651);
        return p;
    }

    @Override
    public void onModSetup() {
        super.onModSetup();

        RecipeTemplate.register(WorkbenchContructingRecipe.class, (old, from, to) -> {
            List<StackedIngredient> newList = convertStackedIngredients(old.getMaterials(), from, to);
            class_1799 originalResult = old.method_8110(class_5455.field_40585);
            class_1799 newResult = RecipeTemplate.convertItemStack(originalResult, from, to);
            if (newResult == null) {
                throw new UnsupportedOperationException("Failed to convert recipe result");
            } else {
                class_2371<StackedIngredient> ingredients = class_2371.method_10212(StackedIngredient.EMPTY, newList.toArray(StackedIngredient[]::new));
                return new WorkbenchContructingRecipe(ingredients, newResult, old.method_49188());
            }
        });
    }


    private static <R extends class_1860<?>, T extends BlockType> @NotNull List<StackedIngredient> convertStackedIngredients(
            class_2371<StackedIngredient> or, T from, T to) {

        List<StackedIngredient> newList = new ArrayList<>();
        for (StackedIngredient si : or) {
            if (si.ingredient().method_8103()) {
                newList.add(si);
            } else {
                newList.add(StackedIngredient.of(
                        BlockTypeSwapIngredient.create(si.ingredient(), from, to),
                        si.count()));
            }
        }
        return newList;
    }

}
