/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.ECRegistry;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.ErrorMessageScreen;
import net.mehvahdjukaar.every_compat.misc.WoodTypeCycleItemRenderer;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class EveryCompatClient {
    public static void init() {
        ClientHelper.addClientSetup(EveryCompatClient::clientSetup);
        EveryCompat.forAllModules(CompatModule::onClientInit);
        ClientHelper.addBlockEntityRenderersRegistration(EveryCompatClient::registerBlockEntityRenderers);
        ClientHelper.addBlockColorsRegistration(EveryCompatClient::registerBlockColors);
        ClientHelper.addItemColorsRegistration(EveryCompatClient::registerItemColors);
        RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)ClientDynamicResourcesHandler.getInstance());
        ClientHelper.addItemRenderersRegistration(event -> event.register((ItemLike)ECRegistry.ALL_WOODS.get(), (ItemStackRenderer)new WoodTypeCycleItemRenderer()));
    }

    public static void onFirstScreen(Screen screen) {
        List<String> errors = EveryCompat.getModulesThatErrored();
        if (!errors.isEmpty()) {
            Minecraft.getInstance().setScreen((Screen)ErrorMessageScreen.create(screen, errors));
        }
        EveryCompat.canShowErrorScreen = false;
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        EveryCompat.forAllModules(m -> m.registerBlockColors(event));
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        EveryCompat.forAllModules(m -> m.registerItemColors(event));
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        EveryCompat.forAllModules(m -> m.registerBlockEntityRenderers(event));
    }

    public static void clientSetup() {
        EveryCompat.forAllModules(CompatModule::onClientSetup);
    }

    public static void onItemTooltip(ItemStack stack, Item.TooltipContext tooltipContext, TooltipFlag tooltipFlag, List<Component> components) {
        Item item;
        CompatModule compatModule;
        boolean modTooltip = ECConfigs.MOD_TOOPTIP.get();
        boolean blockTooltip = ECConfigs.BLOCK_TYPE_TOOLTIP.get();
        if ((modTooltip || blockTooltip && (tooltipFlag.isAdvanced() || !ECConfigs.TOOLTIPS_ADVANCED.get().booleanValue())) && (compatModule = EveryCompat.getModuleOfItem(item = stack.getItem())) != null) {
            if (blockTooltip) {
                BlockType woodType = WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)item);
                if (woodType == null) {
                    woodType = LeavesTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)item);
                }
                if (woodType != null) {
                    components.add((Component)Component.translatable((String)"tooltip.everycomp.wood_type", (Object[])new Object[]{woodType.toString()}).withStyle(ChatFormatting.DARK_GREEN));
                }
            }
            if (modTooltip) {
                components.add((Component)Component.translatable((String)"tooltip.everycomp.mod", (Object[])new Object[]{compatModule.getModName()}).withStyle(ChatFormatting.BLUE));
            }
        }
    }

    public static <B extends Block> void registerRenderType(B b, BlockType bt, Object type) {
        if (bt.id.equals((Object)ResourceLocation.tryParse((String)"rats:pirat"))) {
            type = RenderLayer.TRANSLUCENT;
        }
        if (type == null) {
            return;
        }
        if (type instanceof RenderLayer) {
            RenderLayer rl = (RenderLayer)((Object)type);
            switch (rl) {
                case CUTOUT: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.cutout());
                    break;
                }
                case CUTOUT_MIPPED: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.cutoutMipped());
                    break;
                }
                case TRANSLUCENT: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.translucent());
                    break;
                }
                case SOLID: {
                    ClientHelper.registerRenderType(b, (RenderType)RenderType.solid());
                }
            }
        } else if (type instanceof Supplier) {
            Supplier s = (Supplier)type;
            RenderType renderType = (RenderType)((Supplier)s.get()).get();
            ClientHelper.registerRenderType(b, (RenderType)renderType);
        } else if (PlatHelper.isDev()) {
            throw new IllegalArgumentException("Invalid render type: " + String.valueOf(type));
        }
    }
}

