/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.dynamicpack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ECConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicServerResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ServerDynamicResourcesHandler
extends DynamicServerResourceProvider {
    private static ServerDynamicResourcesHandler INSTANCE;

    public static ServerDynamicResourcesHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServerDynamicResourcesHandler();
        }
        return INSTANCE;
    }

    public ServerDynamicResourcesHandler() {
        super(EveryCompat.res("dynamic_resources"), ECConfigs.SERVER_GENERATION_MODE.get().pickStrategy());
    }

    protected Collection<String> gatherSupportedNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("minecraft");
        namespaces.add("everycomp");
        if (PlatHelper.isModLoaded((String)"lolmcv")) {
            namespaces.add("lieonstudio");
        }
        if (ECConfigs.GENERATE_WOOD_TAGS.get().booleanValue()) {
            namespaces.addAll(EveryCompat.getDependencies());
        }
        return namespaces;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        ArrayList tasks = new ArrayList();
        EveryCompat.forAllModules(m -> m.addDynamicServerResources(tasks::add));
        int minBatches = Runtime.getRuntime().availableProcessors();
        int maxBatches = tasks.size() / Runtime.getRuntime().availableProcessors();
        int batchSize = Math.max(minBatches, maxBatches);
        EveryCompat.LOGGER.info("Every Compat is starting dynamic server resources generation tasks: {} in batches of {}", (Object)tasks.size(), (Object)batchSize);
        for (int i = 0; i < tasks.size(); i += batchSize) {
            int end = Math.min(i + batchSize, tasks.size());
            List subList = tasks.subList(i, end);
            executor.accept((resourceManager, resourceSink) -> {
                for (ResourceGenTask task : subList) {
                    task.accept(resourceManager, resourceSink);
                }
            });
        }
        if (ECConfigs.GENERATE_WOOD_TAGS.get().booleanValue()) {
            executor.accept((resourceManager, resourceSink) -> {
                for (BlockTypeRegistry r : BlockSetAPI.getRegistries()) {
                    String typeName = r.typeName();
                    for (BlockType type : r.getValues()) {
                        ResourceLocation id = type.getId().withPrefix(typeName + "/");
                        SimpleTagBuilder itemTag = SimpleTagBuilder.of((ResourceLocation)id);
                        SimpleTagBuilder blockTag = SimpleTagBuilder.of((ResourceLocation)id);
                        boolean oneItem = false;
                        boolean oneBlock = false;
                        for (Map.Entry c : type.getChildren()) {
                            Item item;
                            String key = (String)c.getKey();
                            Block block = type.getBlockOfThis(key);
                            if (block != null) {
                                oneBlock = true;
                                blockTag.addEntry((Object)block);
                            }
                            if ((item = type.getItemOfThis(key)) == null) continue;
                            oneItem = true;
                            itemTag.addEntry((Object)item);
                        }
                        if (oneBlock) {
                            resourceSink.addTag(blockTag, Registries.BLOCK);
                        }
                        if (!oneItem) continue;
                        resourceSink.addTag(itemTag, Registries.ITEM);
                    }
                }
            });
        }
    }
}

