package net.mehvahdjukaar.every_compat.modules.fabric.building_but_better;

import com.starfish_studios.bbb.block.*;
import com.starfish_studios.bbb.item.DescriptionBlockItem;
import com.starfish_studios.bbb.registry.BBBTags.BBBBlockTags;
import com.starfish_studios.bbb.registry.BBBTags.BBBItemTags;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.RenderLayer;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2465;
import net.minecraft.class_2510;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7924;

// IMPORTANT:
// FABRIC version of this module is already included in the mod. It's currently OUTDATED

//SUPPORT: v1.0.2+
public class BuildingButBetterModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> layers;
    public final SimpleEntrySet<WoodType, class_2248> trims;
    public final SimpleEntrySet<WoodType, class_2248> beams;
    public final SimpleEntrySet<WoodType, class_2248> beamStairs;
    public final SimpleEntrySet<WoodType, class_2248> beamSlabs;
    public final SimpleEntrySet<WoodType, class_2248> supports;
    public final SimpleEntrySet<WoodType, class_2248> frames;
    public final SimpleEntrySet<WoodType, class_2248> pallets;
    public final SimpleEntrySet<WoodType, class_2248> lanterns;
    public final SimpleEntrySet<WoodType, class_2248> ladders;
    public final SimpleEntrySet<WoodType, class_2248> walls;

    public BuildingButBetterModule(String modId) {
        super(modId, "bbb");
        class_5321<class_1761> tab = class_7706.field_40195;

        layers = SimpleEntrySet.builder(WoodType.class, "layer",
                        getModBlock("oak_layer"), () -> VanillaWoodTypes.OAK,
                        w -> new LayerBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("slab") //REASON: recipes
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("wooden_layers"), class_7924.field_41254)
                .addTag(BBBBlockTags.LAYERS, class_7924.field_41254)
                .addTag(BBBItemTags.LAYERS, class_7924.field_41197)
                .addTag(modRes("wooden_layers"), class_7924.field_41197)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .copyParentDrop()
                .addModelTransform(BlockTypeResTransformer::replaceOakPlanks)
                .build();
        this.addEntry(layers);

        trims = SimpleEntrySet.builder(WoodType.class, "trim",
                        getModBlock("oak_trim"), () -> VanillaWoodTypes.OAK,
                        w -> new FacingConnectingBlock(Utils.copyPropertySafe(w.planks))
                )
                .addTexture(modRes("block/trim/oak_bottom"))
                .addTexture(modRes("block/trim/oak_middle"))
                .addTexture(modRes("block/trim/oak_none"))
                .addTexture(modRes("block/trim/oak_top"))
                .addTexture(modRes("block/trim/oak_top_face"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("trims"), class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(trims);

        beams = SimpleEntrySet.builder(WoodType.class, "beam",
                        getModBlock("oak_beam"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2465(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .addTag(class_3481.field_15471, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beams);

        beamStairs = SimpleEntrySet.builder(WoodType.class, "beam_stairs",
                        getModBlock("oak_beam_stairs"), () -> VanillaWoodTypes.OAK,
                        w -> new class_2510(w.planks.method_9564(), Utils.copyPropertySafe(w.planks))
                )
                .addCondition(w -> (beams.blocks.get(w) != null)) //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .addTag(class_3481.field_15502, class_7924.field_41254)
                .addTag(class_3481.field_15459, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beamStairs);

        beamSlabs = SimpleEntrySet.builder(WoodType.class, "beam_slab",
                        getModBlock("oak_beam_slab"), () -> VanillaWoodTypes.OAK,
                        w -> new FacingSlabBlock(Utils.copyPropertySafe(w.planks))
                )
                .addCondition(w -> (beams.blocks.get(w) != null)) //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("beams"), class_7924.field_41254)
                .addTag(class_3481.field_15468, class_7924.field_41254)
                .addTag(class_3481.field_15469, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(beamSlabs);

        supports = SimpleEntrySet.builder(WoodType.class, "support",
                        getModBlock("oak_support"), () -> VanillaWoodTypes.OAK,
                        w -> new SupportBlock(Utils.copyPropertySafe(w.planks).method_22488())
                )
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41254)
                .addTag(modRes("supports"), class_7924.field_41197)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(supports);

        frames = SimpleEntrySet.builder(WoodType.class, "frame",
                        getModBlock("oak_frame"), () -> VanillaWoodTypes.OAK,
                        w -> new FrameBlock(Utils.copyPropertySafe(w.planks).method_22488().method_9634().method_50012(class_3619.field_15971))
                )
                .requiresChildren("slab") //REASON: recipes
                .addTexture(modRes("block/frame/oak_frame"))
                .addTexture(modRes("block/frame/oak_frame_sticks"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(new class_2960("create", "movable_empty_collider"), class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("frames"), class_7924.field_41254)
                .addTag(modRes("frames"), class_7924.field_41197)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(frames);

        pallets = SimpleEntrySet.builder(WoodType.class, "pallet",
                        getModBlock("oak_pallet"), () -> VanillaWoodTypes.OAK,
                        w -> new PalletBlock(Utils.copyPropertySafe(w.planks).method_22488())
                )
                .addTexture(modRes("block/pallet/oak_pallet"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("pallets"), class_7924.field_41254)
                .addTag(modRes("pallets"), class_7924.field_41197)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(pallets);

        lanterns = SimpleEntrySet.builder(WoodType.class, "lantern",
                        getModBlock("oak_lantern"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenLanternBlock(Utils.copyPropertySafe(w.planks).method_9631((blockStatex) -> 15))
                )
                .requiresChildren("slab") //REASON: recipes
                .addTexture(modRes("block/lantern/oak"))
//                .addTextureM(modRes("block/lantern/oak"), EveryCompat.res("block/bbb/oak_lantern_m")) //REASON: the texture is 18x16, mask_texture had to be removed
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_lanterns"), class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(modRes("lanterns"), class_7924.field_41197)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(lanterns);

        ladders = SimpleEntrySet.builder(WoodType.class, "ladder",
                        getModBlock("oak_ladder"), () -> VanillaWoodTypes.OAK,
                        w -> new BBBLadderBlock(1, Utils.copyPropertySafe(class_2246.field_9983))
                )
                .setRenderType(RenderLayer.CUTOUT_MIPPED)
                .addTexture(modRes("block/ladder/acacia/oak"))
                .addTexture(modRes("block/ladder/birch/oak"))
                .addTexture(modRes("block/ladder/cherry/oak"))
                .addTexture(modRes("block/ladder/crimson/oak"))
                .addTexture(modRes("block/ladder/dark_oak/oak"))
                .addTexture(modRes("block/ladder/jungle/oak"))
                .addTexture(modRes("block/ladder/mangrove/oak"))
                .addTexture(modRes("block/ladder/oak/oak"))
                .addTextureM(modRes("block/ladder/spruce/oak"), EveryCompat.res("block/bbb/spruce-oak_ladder_m"))
                .addTexture(modRes("block/ladder/warped/oak"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("ladders"), class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(class_3481.field_22414, class_7924.field_41254)
                .addTag(class_3481.field_36327, class_7924.field_41254)
                .addTag(modRes("ladders"), class_7924.field_41197)
                .setTabKey(tab)
                .addCustomItem((wood, block, properties) -> new DescriptionBlockItem(block, properties))
                .defaultRecipe()
                .build();
        this.addEntry(ladders);

        walls = SimpleEntrySet.builder(WoodType.class, "wall",
                        getModBlock("oak_wall"), () -> VanillaWoodTypes.OAK,
                        w -> new WoodenWallBlock(Utils.copyPropertySafe(w.planks))
                )
                .requiresChildren("stripped_log") //REASON: recipes
                .addTexture(modRes("block/beam/oak"))
                .addTexture(modRes("block/beam/oak_top"))
                .addTag(class_3481.field_33715, class_7924.field_41254)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(modRes("wooden_walls"), class_7924.field_41254)
                .addTag(modRes("wooden_blocks"), class_7924.field_41254)
                .addTag(class_3481.field_15504, class_7924.field_41254)
                .defaultRecipe()
                .setTabKey(tab)
                .build();
        this.addEntry(walls);
    }
}