package net.mehvahdjukaar.every_compat.modules.friendsandfoes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSet.Builder;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4158;
import net.minecraft.class_4481;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import java.util.Set;
import java.util.function.Supplier;

//SUPPORT: V3.0.9+
public class FriendsAndFoesModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> beehives;

    // Point-Of-Interest for Beehives
    protected final class_2960 poiId = EveryCompat.res("faf_beehive");

    public final Supplier<class_4158> compatBeeHivePOI = RegHelper.registerPOI(poiId,
            () -> new class_4158(getBeehives(), 1, 1));

    private Set<class_2680> getBeehives() {
        var set = new ImmutableSet.Builder<class_2680>();
        beehives.blocks.values().forEach(b -> set.addAll(b.method_9595().method_11662()));
        return set.build();
    }

    public FriendsAndFoesModule(String modId) {
        super(modId, "faf");

        beehives = SimpleEntrySet.builder(WoodType.class, "beehive",
                        getModBlock("spruce_beehive"), () -> VanillaWoodTypes.SPRUCE,
                        w -> new class_4481(Utils.copyPropertySafe(class_2246.field_20422))
                )
                .addTile(() -> class_2591.field_20431)
                .addTextureM(EveryCompat.res("block/spruce_beehive_front_honey"),
                        EveryCompat.res("block/spruce_beehive_front_honey_m"))
                .addTextureM(EveryCompat.res("block/spruce_beehive_front"),
                        EveryCompat.res("block/spruce_beehive_front_m"))
                .addTextureM(EveryCompat.res("block/spruce_beehive_side"),
                        EveryCompat.res("block/spruce_beehive_side_m"))
                .addTexture(EveryCompat.res("block/spruce_beehive_end"))
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .addTag(class_3481.field_20340, class_7924.field_41254)
                .setTabKey(class_7706.field_40195)
                .defaultRecipe()
                .copyParentDrop()
                .build();
        this.addEntry(beehives);

    }

//    @Override
//    public void onModSetup() {
//        super.onModSetup();
    /// Currently not working properly in FORGE, crashed upon creating a world or loading a world, cause is unknown
//        RegHelper.addBlocksToPOI(PoiTypes.BEEHIVE, beehives.blocks.values());
//    }
}