package net.mehvahdjukaar.every_compat.modules.table_top_craft;

import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.objects.blocks.ChessTimerBlock;
import andrews.table_top_craft.objects.blocks.ConnectFourBlock;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7924;

//SUPPORT: FORGE-v6.1.0+ | FABRIC-v5.0.0+
public class TableTopCraftModule extends SimpleModule {

    public final SimpleEntrySet<WoodType, class_2248> chessBoards;
    public final SimpleEntrySet<WoodType, class_2248> chessTimers;
    public final SimpleEntrySet<WoodType, class_2248> connectFours;

    public TableTopCraftModule(String modId) {
        super(modId, "ttc");
        var tab = modRes("tab");

        chessBoards = SimpleEntrySet.builder(WoodType.class, "chess",
                        getModBlock("oak_chess"), () -> VanillaWoodTypes.OAK,
                        w -> new ChessBlock(w.getColor(), w.getSound()))
                .addTile(getModTile("chess"))
                .addTag(modRes("chess_boards"), class_7924.field_41197)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(chessBoards);

        chessTimers = SimpleEntrySet.builder(WoodType.class, "chess_timer",
                        getModBlock("oak_chess_timer"), () -> VanillaWoodTypes.OAK,
                        w -> new ChessTimerBlock(w.getColor(), w.getSound()))
                .addTile(getModTile("chess_timer"))
                .addTag(modRes("chess_timers"), class_7924.field_41197)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(chessTimers);

        connectFours = SimpleEntrySet.builder(WoodType.class, "connect_four",
                        getModBlock("oak_connect_four"), () -> VanillaWoodTypes.OAK,
                        w -> new ConnectFourBlock(w.getColor(), w.getSound()))
                .addTile(getModTile("connect_four"))
                .addTag(modRes("connect_four"), class_7924.field_41197)
                .addTag(class_3481.field_33713, class_7924.field_41254)
                .setTabKey(tab)
                .defaultRecipe()
                .build();
        this.addEntry(connectFours);
    }
}