/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.utils.CommandUtils;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigEnumValueCommand<T extends Enum<T>>
implements ICommand {
    private final String name;
    private final Class<T> clazz;
    private final Function<CommandSourceStack, ForgeConfigSpec.EnumValue<T>> configGetter;

    public ConfigEnumValueCommand(String name, Class<T> clazz, Function<CommandSourceStack, ForgeConfigSpec.EnumValue<T>> configGetter) {
        this.name = name;
        this.clazz = clazz;
        this.configGetter = configGetter;
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)this.name).executes(this::defaultExecute);
        for (Enum value : (Enum[])this.clazz.getEnumConstants()) {
            command = (LiteralArgumentBuilder)command.then(Commands.literal((String)value.toString()).executes(cc -> this.setValue((CommandContext<CommandSourceStack>)cc, value)));
        }
        return command;
    }

    @Override
    public String getHelpText(CommandContext<CommandSourceStack> commandContext) {
        return "";
    }

    private int defaultExecute(CommandContext<CommandSourceStack> cc) {
        CommandUtils.sendMessage(cc, String.format("'%s' value: '%s'", this.name, ((Enum)this.configGetter.apply((CommandSourceStack)cc.getSource()).get()).toString()));
        return 1;
    }

    private int setValue(CommandContext<CommandSourceStack> cc, T value) {
        ForgeConfigSpec.EnumValue<T> config = this.configGetter.apply((CommandSourceStack)cc.getSource());
        config.set(value);
        config.save();
        CommandUtils.sendMessage(cc, String.format("'%s' value is now '%s'", this.name, ((Enum)this.configGetter.apply((CommandSourceStack)cc.getSource()).get()).toString()));
        return 1;
    }
}

