/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.config;

import dev.tourmi.svmm.utils.PredicateUtils;
import java.text.MessageFormat;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public enum TriggerActions {
    SHIFT_HELD("while holding shift", Entity::isShiftKeyDown),
    SHIFT_NOT_HELD("while not holding shift", TriggerActions.SHIFT_HELD.triggerCondition.negate()),
    ALWAYS(PredicateUtils::always);

    private final Predicate<Player> triggerCondition;
    public final String description;

    private TriggerActions(Predicate<Player> triggerCondition) {
        this("", triggerCondition);
    }

    private TriggerActions(String description, Predicate<Player> triggerCondition) {
        this.triggerCondition = triggerCondition;
        this.description = description;
    }

    public boolean shouldTrigger(Player player) {
        return this.triggerCondition.test(player);
    }

    public String formatConditionText(String baseMessage, String addedText) {
        if (this.description.isEmpty()) {
            return MessageFormat.format(baseMessage, "");
        }
        return MessageFormat.format(baseMessage, MessageFormat.format(addedText, this.description));
    }

    public String toString() {
        return super.toString().toLowerCase();
    }
}

