/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.utils;

import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.utils.EnchantUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public final class MinecraftUtils {
    public static final HashMap<BlockPos, Player> BLOCKS_MINED = new HashMap();

    public static Stream<String> getColorNames() {
        return Stream.of("white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black");
    }

    public static String getBlockName(BlockState bs) {
        String stateString = bs.toString();
        if (!stateString.contains("{") || !stateString.contains("}")) {
            return stateString;
        }
        return stateString.substring(stateString.indexOf(123) + 1, stateString.indexOf(125));
    }

    public static boolean isBlockInList(BlockState bs, List<? extends String> list) {
        if (list.contains(MinecraftUtils.getBlockName(bs))) {
            return true;
        }
        List<String> tags = list.stream().filter(e -> e.startsWith("#")).map(e -> e.substring(1)).toList();
        return tags.stream().map(t -> ForgeRegistries.BLOCKS.tags().createTagKey(ResourceLocation.parse((String)t))).anyMatch(arg_0 -> ((BlockState)bs).is(arg_0));
    }

    public static void mineBlock(ServerLevel level, ServerPlayer player, BlockPos blockPos, ItemStack heldItem) {
        if (level.isClientSide()) {
            return;
        }
        BlockState blockState = level.getBlockState(blockPos);
        heldItem.mineBlock((Level)level, blockState, blockPos, (Player)player);
        blockState.getBlock().popExperience(level, blockPos, EnchantUtils.getExp((Level)level, heldItem, blockPos, blockState));
        blockState.getBlock().playerDestroy((Level)level, (Player)player, blockPos, blockState, level.getBlockEntity(blockPos), heldItem);
        level.removeBlock(blockPos, false);
        if (((Boolean)SVMMConfig.TELEPORT_ITEMS_TO_PLAYER.get()).booleanValue()) {
            BLOCKS_MINED.put(blockPos, (Player)player);
            level.getServer().execute(() -> BLOCKS_MINED.remove(blockPos));
        }
    }

    public static void mineBlocks(ServerLevel level, ServerPlayer player, ItemStack heldItem, Collection<BlockPos> blocks) {
        boolean letItemBreak = (Boolean)SVMMConfig.STOP_WHEN_ABOUT_TO_BREAK.get() == false;
        for (BlockPos pos : blocks) {
            if (MinecraftUtils.shouldStopMining(letItemBreak, heldItem)) break;
            MinecraftUtils.mineBlock(level, player, pos, heldItem);
        }
    }

    private static boolean shouldStopMining(boolean letItemBreak, ItemStack item) {
        if (!letItemBreak && item.getMaxDamage() - item.getDamageValue() <= 2) {
            return true;
        }
        return item.isEmpty();
    }
}

