/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tourmi.svmm.commands.CommandPredicates;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.config.ClientConfig;
import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.config.TriggerActions;
import dev.tourmi.svmm.server.ClientStatus;
import dev.tourmi.svmm.utils.CommandUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class ForceCommand
implements ICommand {
    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"force").requires(CommandPredicates::isForceVeinMiningEnabled)).requires(CommandPredicates::isPlayer)).requires(CommandPredicates::canPlayerAccessForceVeinMining)).executes(this::defaultExecute);
    }

    public int defaultExecute(CommandContext<CommandSourceStack> cc) {
        if (!this.checkIsAllowed(cc)) {
            return 0;
        }
        ServerPlayer player = ((CommandSourceStack)cc.getSource()).m_230896_();
        if (player == null) {
            return 0;
        }
        ClientStatus status = ClientStatus.getClientStatus(player.m_20148_());
        ClientConfig cfg = CommandUtils.getSourceConfig(cc);
        status.forceNext = !status.forceNext;
        String message = status.forceNext ? ((TriggerActions)((Object)cfg.TRIGGER_WHEN.get())).formatConditionText("Next block mined{0} will be vein mined", " {0}") : "Cancelled vein mine";
        ServerPlayer serverPlayer = player;
        serverPlayer.m_213846_((Component)Component.m_237113_((String)message));
        return 1;
    }

    @Override
    public String getHelpText(CommandContext<CommandSourceStack> cc) {
        if (CommandUtils.isConsole(cc)) {
            return "";
        }
        ClientConfig cfg = CommandUtils.getSourceConfig(cc);
        if (!CommandUtils.isModerator(cc) && (((Boolean)cfg.MOD_DISABLED.get()).booleanValue() || ((Boolean)cfg.FORCE_RESTRICTED.get()).booleanValue())) {
            return "";
        }
        return "- /svmm force\n    Forces a vein mine on the next block mined\n";
    }

    private boolean checkIsAllowed(CommandContext<CommandSourceStack> cc) {
        boolean isAllowed;
        if (CommandUtils.isConsole(cc)) {
            CommandUtils.sendMessage(cc, "Only players may use this command");
            return false;
        }
        ClientConfig cfg = CommandUtils.getSourceConfig(cc);
        boolean isModerator = CommandUtils.isModerator(cc);
        boolean bl = isAllowed = isModerator || (Boolean)SVMMConfig.FORCE_DISABLED.get() == false && (Boolean)cfg.FORCE_RESTRICTED.get() == false && (Boolean)cfg.MOD_RESTRICTED.get() == false;
        if (!isAllowed) {
            CommandUtils.sendMessage(cc, "You do not have access to this command.");
        }
        return isAllowed;
    }
}

