/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tourmi.svmm.commands.CommandPredicates;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.config.ClientConfig;
import dev.tourmi.svmm.config.TriggerActions;
import dev.tourmi.svmm.utils.CommandUtils;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public final class HelpCommand
implements ICommand {
    private final Collection<ICommand> commands;

    public HelpCommand(Collection<ICommand> commands) {
        this.commands = commands;
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"help").executes(this::execute)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tunnel").requires(CommandPredicates::isTunnelingEnabled)).requires(CommandPredicates::isPlayer)).requires(CommandPredicates::canPlayerAccessTunneling)).executes(this::executeTunnel));
    }

    public int execute(CommandContext<CommandSourceStack> commandContext) {
        CommandUtils.sendMessage(commandContext, this.getHelpMessage(commandContext));
        return 1;
    }

    @Override
    public String getHelpText(CommandContext<CommandSourceStack> cc) {
        return "- /svmm help\n    shows this help message\n";
    }

    private String getHelpMessage(CommandContext<CommandSourceStack> cc) {
        StringBuilder str = new StringBuilder("SVMM allows you to mine veins of ore instantly.");
        if (CommandUtils.isPlayer(cc)) {
            ClientConfig cfg = CommandUtils.getSourceConfig(cc);
            ((TriggerActions)((Object)cfg.TRIGGER_WHEN.get())).formatConditionText("{0}", " Mining a block {0} will trigger the mod.");
        }
        str.append("\n");
        for (ICommand command : this.commands) {
            str.append(command.getHelpText(cc));
        }
        return str.toString().trim();
    }

    public int executeTunnel(CommandContext<CommandSourceStack> cc) {
        if (CommandUtils.isConsole(cc)) {
            return 0;
        }
        ClientConfig cfg = CommandUtils.getSourceConfig(cc);
        String baseMessage = "This command allows to automatically dig tunnels.{0}\nWhen using an even number for one of the dimensions of the tunnel, the tunnel center will be rounded towards the top left block\n- /svmm tunnel cancel\n    Cancels the creation of a tunnel on the next block mined.\n- /svmm tunnel {width} {height}\n    The tunnel will have the specified dimensions, and will be as deep as possible\n- /svmm tunnel {width} {height} {maxDepth}\n    The tunnel will have the specified dimensions, and will have the maximum depth specified\n- /svmm tunnel\n    Will reuse the previously specified dimensions for tunneling.";
        String finalMessage = ((TriggerActions)((Object)cfg.TRIGGER_WHEN.get())).formatConditionText(baseMessage, " The next block mined {0} will create the tunnel.");
        CommandUtils.sendMessage(cc, finalMessage);
        return 1;
    }
}

