/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.tourmi.svmm.commands.CommandPredicates;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.config.ClientConfig;
import dev.tourmi.svmm.config.ClientConfigs;
import dev.tourmi.svmm.utils.CommandUtils;
import java.text.MessageFormat;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;

public final class RestrictOrAllowFeaturesCommand
implements ICommand {
    private final boolean restrict;
    private final String action;
    private final String status;
    private final String helpText;

    public RestrictOrAllowFeaturesCommand(boolean restrict) {
        this.restrict = restrict;
        this.action = restrict ? "restrict" : "allow";
        this.status = restrict ? "restricted" : "allowed";
        this.helpText = MessageFormat.format("- /svmm {0} '{player}'\n- /svmm {0} [giantVein|tunnel|force] '{player}'\n    {0}s the mod or specific features for the given player\n", this.action);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)this.action).requires(CommandPredicates::isModerator)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::setModRestriction))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"giantVein").requires(CommandPredicates::isGiantVeinMiningEnabled)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::setGiantVeinRestriction))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tunnel").requires(CommandPredicates::isTunnelingEnabled)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::setTunnelingRestriction)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"force").requires(CommandPredicates::isForceVeinMiningEnabled)).requires(CommandPredicates::canPlayerAccessForceVeinMining)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::setForceRestriction))));
    }

    @Override
    public String getHelpText(CommandContext<CommandSourceStack> cc) {
        if (!CommandUtils.isModerator(cc)) {
            return "";
        }
        return this.helpText;
    }

    private int setModRestriction(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Entity player = EntityArgument.m_91452_(commandContext, (String)"player");
        ClientConfig cfg = ClientConfigs.getClientConfig(player);
        cfg.MOD_RESTRICTED.set((Object)this.restrict);
        cfg.SPEC.save();
        CommandUtils.sendMessage(commandContext, MessageFormat.format("Vein Miner is now {0} for {1}.", this.status, player.m_7755_().getString()));
        return 1;
    }

    private int setGiantVeinRestriction(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Entity player = EntityArgument.m_91452_(commandContext, (String)"player");
        ClientConfig cfg = ClientConfigs.getClientConfig(player);
        cfg.GIANT_VEIN_MINING_RESTRICTED.set((Object)this.restrict);
        cfg.SPEC.save();
        CommandUtils.sendMessage(commandContext, MessageFormat.format("Giant Vein Mining is now {0} for {1}.", this.status, player.m_7755_().getString()));
        return 1;
    }

    private int setTunnelingRestriction(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Entity player = EntityArgument.m_91452_(commandContext, (String)"player");
        ClientConfig cfg = ClientConfigs.getClientConfig(player);
        cfg.TUNNELING_RESTRICTED.set((Object)this.restrict);
        cfg.SPEC.save();
        CommandUtils.sendMessage(commandContext, MessageFormat.format("Tunneling is now {0} for {1}.", this.status, player.m_7755_().getString()));
        return 1;
    }

    private int setForceRestriction(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        Entity player = EntityArgument.m_91452_(commandContext, (String)"player");
        ClientConfig cfg = ClientConfigs.getClientConfig(player);
        cfg.FORCE_RESTRICTED.set((Object)this.restrict);
        cfg.SPEC.save();
        CommandUtils.sendMessage(commandContext, MessageFormat.format("Force Vein Mining is now {0} for {1}.", this.status, player.m_7755_().getString()));
        return 1;
    }
}

