/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tourmi.svmm.commands.CommandPredicates;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.utils.CommandUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ServerConfigCommand
implements ICommand {
    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        LiteralArgumentBuilder configCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"serverConfig").requires(CommandPredicates::isRuntimeConfigEnabled)).requires(CommandPredicates::isModerator)).executes(this::defaultExecute);
        for (ConfigListKeys key : ConfigListKeys.values()) {
            configCommand = (LiteralArgumentBuilder)configCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key.toString()).executes(ctx -> this.executeConfigList((CommandContext<CommandSourceStack>)ctx, key))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.executeAdd((CommandContext<CommandSourceStack>)ctx, key))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.executeRemove((CommandContext<CommandSourceStack>)ctx, key)))));
        }
        return configCommand;
    }

    @Override
    public String getHelpText(CommandContext<CommandSourceStack> cc) {
        if (!CommandUtils.isModerator(cc) || ((Boolean)SVMMConfig.RUNTIME_CONFIG_DISABLED.get()).booleanValue()) {
            return "";
        }
        return "- /svmm serverConfig\n    Lists the available config keys that can be modified\n- /svmm serverConfig {configKey}\n    Displays the value of the config key\n- /svmm serverConfig {configKey} [add|remove] {value}\n    Adds or removes the given {value} to the given {configKey}\n";
    }

    private int defaultExecute(CommandContext<CommandSourceStack> cc) {
        CommandUtils.sendMessage(cc, "Available configuration keys:");
        CommandUtils.sendMessage(cc, Arrays.stream(ConfigListKeys.values()).map(Enum::name).collect(Collectors.joining(", ")));
        return 1;
    }

    private int executeConfigList(CommandContext<CommandSourceStack> cc, ConfigListKeys key) {
        CommandUtils.sendMessage(cc, "Values in " + String.valueOf((Object)key) + ":\n" + String.join((CharSequence)", ", (Iterable)key.config.get()));
        return 1;
    }

    private int executeAdd(CommandContext<CommandSourceStack> cc, ConfigListKeys key) {
        ArrayList<String> newList = new ArrayList<String>(((List)key.config.get()).stream().map(String::toString).toList());
        String value = (String)cc.getArgument("value", String.class);
        newList.add(value);
        key.config.set(newList);
        key.config.save();
        CommandUtils.sendMessage(cc, "Successfully added " + value + " to " + key.name() + " list");
        return 1;
    }

    private int executeRemove(CommandContext<CommandSourceStack> cc, ConfigListKeys key) {
        ArrayList<String> newList = new ArrayList<String>(((List)key.config.get()).stream().map(String::toString).toList());
        String value = (String)cc.getArgument("value", String.class);
        newList.remove(value);
        key.config.set(newList);
        key.config.save();
        CommandUtils.sendMessage(cc, "Successfully removed " + value + " from " + key.name() + " list");
        return 1;
    }

    private static enum ConfigListKeys {
        BLOCK_WHITE_LIST(SVMMConfig.BLOCK_WHITELIST),
        BLOCK_BLACK_LIST(SVMMConfig.BLOCK_BLACKLIST),
        GIANT_VEIN_STARTER_ORE(SVMMConfig.GIANT_VEIN_STARTER_BLOCKS),
        GIANT_VEIN_WHITELIST(SVMMConfig.GIANT_VEIN_WHITELIST),
        GIANT_VEIN_BLACKLIST(SVMMConfig.GIANT_VEIN_BLACKLIST),
        TUNNELING_WHITELIST(SVMMConfig.TUNNELING_WHITELIST),
        TUNNELING_BLACKLIST(SVMMConfig.TUNNELING_BLACKLIST),
        FORCE_BLACKLIST(SVMMConfig.FORCE_BLACKLIST);

        final ForgeConfigSpec.ConfigValue<List<? extends String>> config;

        private ConfigListKeys(ForgeConfigSpec.ConfigValue<List<? extends String>> config) {
            this.config = config;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

