/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tourmi.svmm.commands.CommandPredicates;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.config.ClientConfig;
import dev.tourmi.svmm.utils.CommandUtils;
import java.text.MessageFormat;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ToggleFeaturesCommand
implements ICommand {
    private final boolean disable;
    private final String action;
    private final String status;
    private final String helpText;

    public ToggleFeaturesCommand(boolean disable) {
        this.disable = disable;
        this.action = disable ? "disable" : "enable";
        this.status = disable ? "disabled" : "enabled";
        this.helpText = MessageFormat.format("- /svmm {0} [giantVein]\n    {0}s the mod or specific features for yourself\n", this.action);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)this.action).requires(CommandPredicates::isPlayer)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"giantVein").requires(CommandPredicates::isGiantVeinMiningEnabled)).requires(CommandPredicates::canPlayerAccessGiantVeinMining)).executes(this::toggleGiantVein))).executes(this::toggle);
    }

    @Override
    public String getHelpText(CommandContext<CommandSourceStack> cc) {
        if (CommandUtils.isConsole(cc)) {
            return "";
        }
        return this.helpText;
    }

    private int toggle(CommandContext<CommandSourceStack> commandContext) {
        if (CommandUtils.isConsole(commandContext)) {
            return 0;
        }
        ClientConfig cfg = CommandUtils.getSourceConfig(commandContext);
        this.toggle(commandContext, cfg, cfg.MOD_DISABLED);
        CommandUtils.sendMessage(commandContext, MessageFormat.format("Vein Mining is now {0}", this.status));
        return 1;
    }

    private int toggleGiantVein(CommandContext<CommandSourceStack> commandContext) {
        if (CommandUtils.isConsole(commandContext)) {
            return 0;
        }
        ClientConfig cfg = CommandUtils.getSourceConfig(commandContext);
        this.toggle(commandContext, cfg, cfg.GIANT_VEIN_MINING_DISABLED);
        CommandUtils.sendMessage(commandContext, MessageFormat.format("Giant Vein Mining is now {0}", this.status));
        return 1;
    }

    private void toggle(CommandContext<CommandSourceStack> cc, ClientConfig cfg, ForgeConfigSpec.BooleanValue toggleFeature) {
        toggleFeature.set((Object)this.disable);
        if (CommandUtils.isModerator(cc)) {
            this.resetModeratorRestrictions(cc, cfg);
        }
        toggleFeature.save();
    }

    private void resetModeratorRestrictions(CommandContext<CommandSourceStack> cc, ClientConfig cfg) {
        cfg.MOD_RESTRICTED.set((Object)false);
        cfg.GIANT_VEIN_MINING_RESTRICTED.set((Object)false);
        cfg.SPEC.save();
    }
}

