/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tourmi.svmm.commands.CommandPredicates;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.config.ClientConfig;
import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.server.ClientStatus;
import dev.tourmi.svmm.server.Tunneler;
import dev.tourmi.svmm.utils.CommandUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public final class TunnelCommand
implements ICommand {
    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tunnel").requires(CommandPredicates::isTunnelingEnabled)).requires(CommandPredicates::isPlayer)).requires(CommandPredicates::canPlayerAccessTunneling)).then(Commands.m_82127_((String)"cancel").executes(this::cancelTunnel))).then(Commands.m_82129_((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"maxDepth", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this::tunnelWidthHeightMaxDepth))).executes(this::tunnelWidthHeight)))).executes(this::tunnel);
    }

    @Override
    public String getHelpText(CommandContext<CommandSourceStack> cc) {
        if (CommandUtils.isConsole(cc)) {
            return "";
        }
        ClientConfig cfg = CommandUtils.getSourceConfig(cc);
        if (!CommandUtils.isModerator(cc) && (((Boolean)cfg.MOD_RESTRICTED.get()).booleanValue() || ((Boolean)cfg.MOD_DISABLED.get()).booleanValue() || ((Boolean)cfg.TUNNELING_RESTRICTED.get()).booleanValue())) {
            return "";
        }
        return "- /svmm tunnel\n    run /svmm help tunnel for more details about this command\n";
    }

    private int tunnel(CommandContext<CommandSourceStack> cc) {
        if (!this.checkIsAllowed(cc)) {
            return 0;
        }
        ClientStatus status = Tunneler.toggleTunneler(((CommandSourceStack)cc.getSource()).m_81373_().m_20148_());
        CommandUtils.sendMessage(cc, status.lastMessage);
        return 1;
    }

    private int tunnelWidthHeight(CommandContext<CommandSourceStack> cc) {
        if (!this.checkIsAllowed(cc)) {
            return 0;
        }
        ClientStatus status = Tunneler.toggleTunneler(((CommandSourceStack)cc.getSource()).m_81373_().m_20148_(), (Integer)cc.getArgument("width", Integer.class), (Integer)cc.getArgument("height", Integer.class));
        CommandUtils.sendMessage(cc, status.lastMessage);
        return 1;
    }

    private int tunnelWidthHeightMaxDepth(CommandContext<CommandSourceStack> cc) {
        if (!this.checkIsAllowed(cc)) {
            return 0;
        }
        ClientStatus status = Tunneler.toggleTunneler(((CommandSourceStack)cc.getSource()).m_81373_().m_20148_(), (Integer)cc.getArgument("width", Integer.class), (Integer)cc.getArgument("height", Integer.class), (Integer)cc.getArgument("maxDepth", Integer.class));
        CommandUtils.sendMessage(cc, status.lastMessage);
        return 1;
    }

    private int cancelTunnel(CommandContext<CommandSourceStack> cc) {
        if (!this.checkIsAllowed(cc)) {
            return 0;
        }
        Tunneler.cancelTunnel(((CommandSourceStack)cc.getSource()).m_81373_().m_20148_());
        return 1;
    }

    private boolean checkIsAllowed(CommandContext<CommandSourceStack> cc) {
        boolean isAllowed;
        if (!((CommandSourceStack)cc.getSource()).m_230897_()) {
            CommandUtils.sendMessage(cc, "Only players may use this command");
            return false;
        }
        ClientConfig cfg = CommandUtils.getSourceConfig(cc);
        boolean isModerator = CommandUtils.isModerator(cc);
        boolean bl = isAllowed = isModerator || (Boolean)SVMMConfig.TUNNELING_DISABLED.get() == false && (Boolean)cfg.TUNNELING_RESTRICTED.get() == false && (Boolean)cfg.MOD_RESTRICTED.get() == false;
        if (!isAllowed) {
            CommandUtils.sendMessage(cc, "You do not have access to this command.");
        }
        return isAllowed;
    }
}

