/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.config;

import com.electronwill.nightconfig.core.EnumGetMethod;
import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.config.TriggerActions;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ClientConfig {
    public final ForgeConfigSpec SPEC;
    public final ForgeConfigSpec.BooleanValue MOD_DISABLED;
    public final ForgeConfigSpec.BooleanValue MOD_RESTRICTED;
    public final ForgeConfigSpec.BooleanValue GIANT_VEIN_MINING_DISABLED;
    public final ForgeConfigSpec.BooleanValue GIANT_VEIN_MINING_RESTRICTED;
    public final ForgeConfigSpec.BooleanValue TUNNELING_RESTRICTED;
    public final ForgeConfigSpec.BooleanValue FORCE_RESTRICTED;
    public final ForgeConfigSpec.EnumValue<TriggerActions> TRIGGER_WHEN;

    public ClientConfig(UUID playerUUID) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("svmm-player-" + playerUUID.toString());
        builder.push("self-config");
        this.TRIGGER_WHEN = builder.comment("Condition for when the mod is triggered").defineEnum("trigger_when", SVMMConfig.TRIGGER_WHEN_DEFAULT, EnumGetMethod.NAME_IGNORECASE, o -> {
            if (o instanceof TriggerActions) return true;
            if (!(o instanceof String)) return false;
            String str = (String)o;
            if (!Arrays.stream(TriggerActions.values()).anyMatch(t -> t.name().equalsIgnoreCase(str))) return false;
            return true;
        }, TriggerActions.class);
        builder.pop();
        builder.push("toggles");
        this.MOD_DISABLED = builder.comment("Whether or not the player disabled the mod for themselves").define("mod_disabled", (Supplier)SVMMConfig.MOD_DEFAULT_DISABLED);
        this.GIANT_VEIN_MINING_DISABLED = builder.comment("Whether or not the player disabled giant vein mining for themselves").define("giant_vein_mining_disabled", (Supplier)SVMMConfig.GIANT_VEIN_MINING_DEFAULT_DISABLED);
        builder.pop();
        builder.push("restrictions");
        this.MOD_RESTRICTED = builder.comment("Whether or not the mod was restricted by an operator").define("mod_restricted", (Supplier)SVMMConfig.MOD_DEFAULT_RESTRICTED);
        this.GIANT_VEIN_MINING_RESTRICTED = builder.comment("Whether or not giant vein mining was restricted by an operator").define("giant_vein_mining_restricted", (Supplier)SVMMConfig.GIANT_VEIN_MINING_DEFAULT_RESTRICTED);
        this.TUNNELING_RESTRICTED = builder.comment("Whether or not tunneling was restricted by an operator").define("tunneling_restricted", (Supplier)SVMMConfig.TUNNELING_DEFAULT_RESTRICTED);
        this.FORCE_RESTRICTED = builder.comment("Whether or not /svmm force was restricted by an operator").define("force_restricted", (Supplier)SVMMConfig.FORCE_DEFAULT_RESTRICTED);
        builder.pop();
        builder.pop();
        this.SPEC = builder.build();
    }
}

