/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.config;

import dev.tourmi.svmm.config.ClientConfig;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class ClientConfigs {
    private static final HashMap<UUID, ClientConfig> clientConfigs = new HashMap();

    public static ClientConfig getClientConfig(Entity player) {
        if (!clientConfigs.containsKey(player.m_20148_())) {
            ClientConfigs.loadOrCreateClientConfig(player);
        }
        return clientConfigs.get(player.m_20148_());
    }

    @Nullable
    public static ClientConfig getClientConfig(UUID uuid) {
        return clientConfigs.getOrDefault(uuid, null);
    }

    private static void loadOrCreateClientConfig(Entity player) {
        UUID playerUUID = player.m_20148_();
        ClientConfig cfg = new ClientConfig(playerUUID);
        String configPath = "svmm-player-configs/" + String.valueOf(playerUUID) + ".toml";
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)cfg.SPEC, configPath);
        Path serverConfig = player.m_20194_().m_129843_(new LevelResource("serverconfig"));
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, serverConfig);
        clientConfigs.put(playerUUID, cfg);
    }
}

