/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.server;

import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.server.ClientStatus;
import dev.tourmi.svmm.utils.MinecraftUtils;
import dev.tourmi.svmm.utils.Utils3D;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public final class Tunneler {
    public static ClientStatus toggleTunneler(UUID playerUUID) {
        ClientStatus status = ClientStatus.getClientStatus(playerUUID);
        return Tunneler.toggleTunneler(playerUUID, status.tunnelWidth, status.tunnelHeight, status.tunnelDeep);
    }

    public static ClientStatus toggleTunneler(UUID playerUUID, int width, int height) {
        return Tunneler.toggleTunneler(playerUUID, width, height, Integer.MAX_VALUE);
    }

    public static ClientStatus toggleTunneler(UUID playerUUID, int width, int height, int maxDepth) {
        ClientStatus status = ClientStatus.getClientStatus(playerUUID);
        boolean bl = status.tunnelNextBlock = !status.tunnelNextBlock;
        if (!status.tunnelNextBlock) {
            status.lastMessage = "Cancelled tunneling";
            return status;
        }
        int maximumDimensions = (Integer)SVMMConfig.TUNNELING_MAX_DIMENSION.get();
        if (width > maximumDimensions || height > maximumDimensions) {
            status.lastMessage = String.format("%dx%d dimensions are invalid for a tunnel. The maximum amount of blocks per dimension is %d", width, height, maximumDimensions);
            status.tunnelNextBlock = false;
            return status;
        }
        status.tunnelWidth = width;
        status.tunnelHeight = height;
        status.tunnelDeep = Integer.min(Integer.min((Integer)SVMMConfig.TUNNELING_MAX_BLOCKS.get() / (width * height), maxDepth), (Integer)SVMMConfig.TUNNELING_MAX_DEPTH.get());
        status.lastMessage = String.format("The next block mined will create a %dx%d tunnel that's maximum %d blocks deep.", width, height, status.tunnelDeep);
        status.forceNext = false;
        return status;
    }

    public static boolean canTunnel(UUID playerUUID) {
        return ClientStatus.getClientStatus((UUID)playerUUID).tunnelNextBlock;
    }

    public static void cancelTunnel(UUID playerUUID) {
        ClientStatus.getClientStatus((UUID)playerUUID).tunnelNextBlock = false;
    }

    public static void updateFaceMined(UUID playerUUID, Direction face) {
        ClientStatus.getClientStatus((UUID)playerUUID).tunnelFaceMined = face;
    }

    public static ClientStatus doTunnel(ServerPlayer player, ServerLevel level, ItemStack heldItem, BlockState blockState, BlockPos blockPos) {
        ClientStatus status = ClientStatus.getClientStatus(player.m_20148_());
        status.tunnelNextBlock = false;
        Collection<BlockPos> blocks = status.tunnelFaceMined.m_122434_() == Direction.Axis.Y ? Utils3D.getVerticalTunnelBlocks(blockPos, blockState, (Level)level, player.m_6350_(), status.tunnelFaceMined, status.tunnelWidth, status.tunnelHeight, status.tunnelDeep) : Utils3D.getTunnelBlocks(blockPos, blockState, (Level)level, status.tunnelFaceMined, status.tunnelWidth, status.tunnelHeight, status.tunnelDeep);
        MinecraftUtils.mineBlocks(level, player, heldItem, blocks);
        status.lastBlocksMined = blocks.size();
        status.lastPosition = blockPos;
        player.m_213846_((Component)Component.m_237113_((String)String.format("Mined %d blocks", status.lastBlocksMined)));
        return status;
    }
}

