/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.server;

import com.mojang.logging.LogUtils;
import dev.tourmi.svmm.config.ClientConfig;
import dev.tourmi.svmm.config.ClientConfigs;
import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.config.TriggerActions;
import dev.tourmi.svmm.server.ClientStatus;
import dev.tourmi.svmm.server.Tunneler;
import dev.tourmi.svmm.utils.MinecraftUtils;
import dev.tourmi.svmm.utils.Utils3D;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.level.BlockEvent;
import org.slf4j.Logger;

public final class VeinMiner {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void onBlockBroken(BlockEvent.BreakEvent event) {
        BlockState blockState;
        ItemStack heldItem;
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (((Boolean)SVMMConfig.MOD_DISABLED.get()).booleanValue()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (!this.canUseMod((Player)player, heldItem = player.m_21205_(), blockState = event.getState())) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_20193_();
        BlockPos blockPos = event.getPos();
        if (this.canTunnel(player, blockState)) {
            this.doTunnel(player, level, heldItem, blockState, blockPos);
        } else if (this.canGiantVeinMine(player, blockState)) {
            this.doGiantVeinMine(player, level, heldItem, blockPos);
        } else if (this.canVeinMine(player, blockState)) {
            this.doVeinMine(player, level, heldItem, blockState, blockPos);
        } else {
            return;
        }
        event.setCanceled(true);
    }

    private boolean canUseMod(Player player, ItemStack heldItem, BlockState minedBlockState) {
        ClientConfig cfg = ClientConfigs.getClientConfig((Entity)player);
        if (((Boolean)cfg.MOD_DISABLED.get()).booleanValue()) {
            return false;
        }
        if (((Boolean)cfg.MOD_RESTRICTED.get()).booleanValue()) {
            return false;
        }
        if (player.m_7500_()) {
            return false;
        }
        if (!((TriggerActions)((Object)cfg.TRIGGER_WHEN.get())).shouldTrigger(player)) {
            return false;
        }
        return heldItem.m_41735_(minedBlockState);
    }

    private boolean canTunnel(ServerPlayer player, BlockState blockState) {
        if (((Boolean)SVMMConfig.TUNNELING_DISABLED.get()).booleanValue()) {
            return false;
        }
        ClientConfig cfg = ClientConfigs.getClientConfig((Entity)player);
        if (((Boolean)cfg.TUNNELING_RESTRICTED.get()).booleanValue()) {
            return false;
        }
        if (!Tunneler.canTunnel(player.m_20148_())) {
            return false;
        }
        if (!this.canMine(blockState, (List)SVMMConfig.TUNNELING_WHITELIST.get(), (List)SVMMConfig.TUNNELING_BLACKLIST.get())) {
            Tunneler.cancelTunnel(player.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)"Cancelled tunneling since the block that was mined is not part of the allowed list of blocks"));
            return false;
        }
        return true;
    }

    private void doTunnel(ServerPlayer player, ServerLevel level, ItemStack heldItem, BlockState blockState, BlockPos blockPos) {
        ClientStatus status = Tunneler.doTunnel(player, level, heldItem, blockState, blockPos);
        if (((Boolean)SVMMConfig.TUNNELING_LOG_USAGE.get()).booleanValue()) {
            LOGGER.info("Player {} tunneled at position {} {} {}, mining {} blocks.", new Object[]{player.m_7755_(), status.lastPosition.m_123341_(), status.lastPosition.m_123342_(), status.lastPosition.m_123343_(), status.lastBlocksMined});
        }
    }

    private boolean canVeinMine(ServerPlayer player, BlockState minedBlockState) {
        ClientStatus status = ClientStatus.getClientStatus(player.m_20148_());
        if (status.forceNext) {
            boolean canForceMine;
            boolean bl = canForceMine = !MinecraftUtils.isBlockInList(minedBlockState, (List)SVMMConfig.FORCE_BLACKLIST.get());
            if (!canForceMine) {
                player.m_213846_((Component)Component.m_237113_((String)"You may not force vein mine this block"));
                status.forceNext = false;
            }
            return canForceMine;
        }
        return this.canMine(minedBlockState, (List)SVMMConfig.BLOCK_WHITELIST.get(), (List)SVMMConfig.BLOCK_BLACKLIST.get());
    }

    private boolean canMine(BlockState blockState, List<? extends String> whitelist, List<? extends String> blacklist) {
        if (MinecraftUtils.isBlockInList(blockState, whitelist)) {
            return !MinecraftUtils.isBlockInList(blockState, blacklist);
        }
        return false;
    }

    private void doVeinMine(ServerPlayer player, ServerLevel level, ItemStack heldItem, BlockState blockState, BlockPos blockPos) {
        MinecraftUtils.mineBlocks(level, player, heldItem, Utils3D.getVeinBlocks(blockState, blockPos, (Level)level, (Integer)SVMMConfig.MAXIMUM_BLOCKS_TO_BREAK.get()));
        ClientStatus status = ClientStatus.getClientStatus(player.m_20148_());
        if (status.forceNext) {
            status.forceNext = false;
            player.m_213846_((Component)Component.m_237113_((String)"Force vein mine completed"));
            if (((Boolean)SVMMConfig.FORCE_LOG_USAGE.get()).booleanValue()) {
                LOGGER.info(player.m_7755_().getString() + " force mined block " + MinecraftUtils.getBlockName(blockState) + " at position " + blockPos.m_123344_());
            }
        }
    }

    private boolean canGiantVeinMine(ServerPlayer player, BlockState minedBlockState) {
        if (((Boolean)SVMMConfig.GIANT_VEIN_MINING_DISABLED.get()).booleanValue()) {
            return false;
        }
        ClientConfig cfg = ClientConfigs.getClientConfig((Entity)player);
        if (((Boolean)cfg.GIANT_VEIN_MINING_DISABLED.get()).booleanValue()) {
            return false;
        }
        if (((Boolean)cfg.GIANT_VEIN_MINING_RESTRICTED.get()).booleanValue()) {
            return false;
        }
        if (ClientStatus.getClientStatus((UUID)player.m_20148_()).forceNext) {
            return false;
        }
        return this.canMine(minedBlockState, (List)SVMMConfig.GIANT_VEIN_STARTER_BLOCKS.get(), (List)SVMMConfig.GIANT_VEIN_BLACKLIST.get());
    }

    private void doGiantVeinMine(ServerPlayer player, ServerLevel level, ItemStack heldItem, BlockPos blockPos) {
        MinecraftUtils.mineBlocks(level, player, heldItem, Utils3D.getGiantVeinBlocks(blockPos, (Level)level, (Integer)SVMMConfig.MAXIMUM_BLOCKS_TO_BREAK.get()));
    }
}

