/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.utils;

import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.utils.EnchantUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public final class MinecraftUtils {
    public static final HashMap<BlockPos, Player> BLOCKS_MINED = new HashMap();

    public static Stream<String> getColorNames() {
        return Stream.of("white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black");
    }

    public static String getBlockName(BlockState bs) {
        String stateString = bs.toString();
        if (!stateString.contains("{") || !stateString.contains("}")) {
            return stateString;
        }
        return stateString.substring(stateString.indexOf(123) + 1, stateString.indexOf(125));
    }

    public static boolean isBlockInList(BlockState bs, List<? extends String> list) {
        if (list.contains(MinecraftUtils.getBlockName(bs))) {
            return true;
        }
        List<String> tags = list.stream().filter(e -> e.startsWith("#")).map(e -> e.substring(1)).toList();
        return tags.stream().map(t -> ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation(t))).anyMatch(arg_0 -> ((BlockState)bs).m_204336_(arg_0));
    }

    public static void mineBlock(ServerLevel level, ServerPlayer player, BlockPos blockPos, ItemStack heldItem) {
        if (level.m_5776_()) {
            return;
        }
        BlockState blockState = level.m_8055_(blockPos);
        heldItem.m_41686_((Level)level, blockState, blockPos, (Player)player);
        blockState.m_60734_().m_49805_(level, blockPos, EnchantUtils.getExp((Level)level, heldItem, blockPos, blockState));
        blockState.m_60734_().m_6240_((Level)level, (Player)player, blockPos, blockState, level.m_7702_(blockPos), heldItem);
        level.m_7471_(blockPos, false);
        if (((Boolean)SVMMConfig.TELEPORT_ITEMS_TO_PLAYER.get()).booleanValue()) {
            BLOCKS_MINED.put(blockPos, (Player)player);
            level.m_7654_().execute(() -> BLOCKS_MINED.remove(blockPos));
        }
    }

    public static void mineBlocks(ServerLevel level, ServerPlayer player, ItemStack heldItem, Collection<BlockPos> blocks) {
        boolean letItemBreak = (Boolean)SVMMConfig.STOP_WHEN_ABOUT_TO_BREAK.get() == false;
        for (BlockPos pos : blocks) {
            if (MinecraftUtils.shouldStopMining(letItemBreak, heldItem)) break;
            MinecraftUtils.mineBlock(level, player, pos, heldItem);
        }
    }

    private static boolean shouldStopMining(boolean letItemBreak, ItemStack item) {
        if (!letItemBreak && item.m_41776_() - item.m_41773_() <= 2) {
            return true;
        }
        return item.m_41619_();
    }
}

