/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.utils;

import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.utils.MinecraftUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public final class Utils3D {
    public static Stream<BlockPos> getSameBlocksConnectedToPos(String blockName, BlockPos pos, Level level) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1)).filter(bpos -> !bpos.equals((Object)pos) && MinecraftUtils.getBlockName(level.m_8055_(bpos)).equals(blockName));
    }

    public static Stream<BlockPos> getGiantVeinBlocksConnectedToPos(BlockPos pos, Level level, List<? extends String> whitelist, List<? extends String> blacklist) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1)).filter(bpos -> !bpos.equals((Object)pos) && MinecraftUtils.isBlockInList(level.m_8055_(bpos), whitelist) && !MinecraftUtils.isBlockInList(level.m_8055_(bpos), blacklist));
    }

    public static Collection<BlockPos> getVeinBlocks(BlockState s, BlockPos p, Level l, int limit) {
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> newPositions = new HashSet<BlockPos>();
        String blockName = MinecraftUtils.getBlockName(s);
        newPositions.add(p);
        while (!newPositions.isEmpty() && visitedBlocks.size() < limit) {
            BlockPos currPos = (BlockPos)newPositions.iterator().next();
            if (visitedBlocks.size() + newPositions.size() < limit) {
                Stream<BlockPos> potentialBlocks = Utils3D.getSameBlocksConnectedToPos(blockName, currPos, l);
                newPositions.addAll(potentialBlocks.filter(pos -> !visitedBlocks.contains(pos)).map(BlockPos::m_7949_).toList());
            }
            visitedBlocks.add(currPos);
            newPositions.remove(currPos);
        }
        return visitedBlocks;
    }

    public static Collection<BlockPos> getGiantVeinBlocks(BlockPos p, Level l, int limit) {
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> newPositions = new HashSet<BlockPos>();
        newPositions.add(p);
        while (!newPositions.isEmpty() && visitedBlocks.size() < limit) {
            BlockPos currPos = (BlockPos)newPositions.iterator().next();
            if (visitedBlocks.size() + newPositions.size() < limit) {
                Stream<BlockPos> potentialBlocks = Utils3D.getGiantVeinBlocksConnectedToPos(currPos, l, (List)SVMMConfig.GIANT_VEIN_WHITELIST.get(), (List)SVMMConfig.GIANT_VEIN_BLACKLIST.get());
                newPositions.addAll(potentialBlocks.filter(pos -> !visitedBlocks.contains(pos)).map(BlockPos::m_7949_).toList());
            }
            visitedBlocks.add(currPos);
            newPositions.remove(currPos);
        }
        return visitedBlocks;
    }

    public static Collection<BlockPos> getTunnelBlocks(BlockPos p, BlockState s, Level l, Direction f, int width, int height, int depth) {
        return Utils3D.getTunnelBlocks(p, s, l, f, Direction.UP, Direction.DOWN, f.m_122427_(), f.m_122428_(), width, height, depth);
    }

    private static Collection<BlockPos> getTunnelBlocks(BlockPos p, BlockState s, Level l, Direction blockFace, Direction upDir, Direction downDir, Direction leftDir, Direction rightDir, int width, int height, int depth) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        int upDist = (height - 1) / 2;
        int downDist = height / 2;
        int leftDist = (width - 1) / 2;
        int rightDist = width / 2;
        for (int i = 0; i < depth; ++i) {
            BlockPos currDepth = p.m_5484_(blockFace.m_122424_(), i);
            Stream<BlockPos> stream = BlockPos.m_121990_((BlockPos)currDepth.m_5484_(leftDir, leftDist).m_5484_(upDir, upDist), (BlockPos)currDepth.m_5484_(rightDir, rightDist).m_5484_(downDir, downDist));
            if (((Boolean)SVMMConfig.TUNNELING_SAME_TYPE.get()).booleanValue()) {
                String blockName = MinecraftUtils.getBlockName(s);
                stream = stream.filter(pos -> MinecraftUtils.getBlockName(l.m_8055_(pos)).equals(blockName));
            } else {
                stream = stream.filter(pos -> MinecraftUtils.isBlockInList(l.m_8055_(pos), (List)SVMMConfig.TUNNELING_WHITELIST.get()) && !MinecraftUtils.isBlockInList(l.m_8055_(pos), (List)SVMMConfig.TUNNELING_BLACKLIST.get()));
            }
            List<BlockPos> res = stream.map(BlockPos::m_7949_).toList();
            blocks.addAll(res);
            if (res.isEmpty()) break;
        }
        return blocks;
    }

    public static Collection<BlockPos> getVerticalTunnelBlocks(BlockPos p, BlockState s, Level l, Direction playerDir, Direction f, int width, int height, int depth) {
        Direction up = playerDir;
        Direction down = playerDir.m_122424_();
        Direction left = playerDir.m_122428_();
        Direction right = playerDir.m_122427_();
        if (f.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            up = down;
            down = playerDir;
        }
        return Utils3D.getTunnelBlocks(p, s, l, f, up, down, left, right, width, height, depth);
    }
}

