/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import dev.tourmi.svmm.config.SVMMConfig;
import dev.tourmi.svmm.utils.CommandUtils;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.ForgeConfigSpec;

public final class CommandPredicates {
    private CommandPredicates() {
    }

    public static boolean isPlayer(CommandSourceStack cs) {
        return cs.isPlayer();
    }

    public static boolean isConsole(CommandSourceStack cs) {
        return !CommandPredicates.isPlayer(cs);
    }

    public static boolean isModerator(CommandSourceStack cs) {
        return cs.hasPermission(2);
    }

    public static boolean isModEnabled(CommandSourceStack cs) {
        return CommandPredicates.isFeatureEnabled(SVMMConfig.MOD_DISABLED);
    }

    public static boolean isGiantVeinMiningEnabled(CommandSourceStack cs) {
        return CommandPredicates.isFeatureEnabled(SVMMConfig.GIANT_VEIN_MINING_DISABLED);
    }

    public static boolean isTunnelingEnabled(CommandSourceStack cs) {
        return CommandPredicates.isFeatureEnabled(SVMMConfig.TUNNELING_DISABLED);
    }

    public static boolean isForceVeinMiningEnabled(CommandSourceStack cs) {
        return CommandPredicates.isFeatureEnabled(SVMMConfig.FORCE_DISABLED);
    }

    public static boolean isRuntimeConfigEnabled(CommandSourceStack cs) {
        return CommandPredicates.isFeatureEnabled(SVMMConfig.RUNTIME_CONFIG_DISABLED);
    }

    public static boolean canPlayerAccessMod(CommandSourceStack cs) {
        return CommandPredicates.canPlayerAccessFeature(cs, () -> CommandUtils.getSourceConfig((CommandSourceStack)cs).MOD_RESTRICTED);
    }

    public static boolean canPlayerAccessGiantVeinMining(CommandSourceStack cs) {
        return CommandPredicates.canPlayerAccessFeature(cs, () -> CommandUtils.getSourceConfig((CommandSourceStack)cs).GIANT_VEIN_MINING_RESTRICTED);
    }

    public static boolean canPlayerAccessTunneling(CommandSourceStack cs) {
        return CommandPredicates.canPlayerAccessFeature(cs, () -> CommandUtils.getSourceConfig((CommandSourceStack)cs).TUNNELING_RESTRICTED);
    }

    public static boolean canPlayerAccessForceVeinMining(CommandSourceStack cs) {
        return CommandPredicates.canPlayerAccessFeature(cs, () -> CommandUtils.getSourceConfig((CommandSourceStack)cs).FORCE_RESTRICTED);
    }

    private static boolean isFeatureEnabled(ForgeConfigSpec.BooleanValue isDisabled) {
        return (Boolean)isDisabled.get() == false;
    }

    private static boolean canPlayerAccessFeature(CommandSourceStack cs, Supplier<ForgeConfigSpec.BooleanValue> isRestricted) {
        return CommandPredicates.isModerator(cs) || (Boolean)isRestricted.get().get() == false;
    }
}

