/*
 * Decompiled with CFR 0.152.
 */
package dev.tourmi.svmm.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.tourmi.svmm.commands.CommandPredicates;
import dev.tourmi.svmm.commands.ConfigCommand;
import dev.tourmi.svmm.commands.ForceCommand;
import dev.tourmi.svmm.commands.HelpCommand;
import dev.tourmi.svmm.commands.ICommand;
import dev.tourmi.svmm.commands.RestrictOrAllowFeaturesCommand;
import dev.tourmi.svmm.commands.ServerConfigCommand;
import dev.tourmi.svmm.commands.ToggleFeaturesCommand;
import dev.tourmi.svmm.commands.TunnelCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.commands.CommandSourceStack;

public final class Commands {
    private static final List<ICommand> commands = new ArrayList<ICommand>(){
        {
            this.add(new ToggleFeaturesCommand(true));
            this.add(new ToggleFeaturesCommand(false));
            this.add(new RestrictOrAllowFeaturesCommand(true));
            this.add(new RestrictOrAllowFeaturesCommand(false));
            this.add(new ForceCommand());
            this.add(new TunnelCommand());
            this.add(new ConfigCommand());
            this.add(new ServerConfigCommand());
            this.add(new HelpCommand(this));
        }
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        HelpCommand helpCommand = commands.stream().filter(c -> c instanceof HelpCommand).map(c -> (HelpCommand)c).reduce((c1, c2) -> {
            throw new IllegalStateException("Only one HelpCommand should exist");
        }).orElseThrow(() -> new NoSuchElementException("A HelpCommand is required"));
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"svmm").requires(CommandPredicates::isModEnabled)).requires(CommandPredicates::canPlayerAccessMod)).executes(helpCommand::execute);
        for (ICommand c3 : commands) {
            command = (LiteralArgumentBuilder)command.then(c3.getCommand());
        }
        dispatcher.register(command);
    }
}

