/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.CloseConfigProcedure;
import mc.sayda.creraces.procedures.LandmineRecipeProcedure;
import mc.sayda.creraces.procedures.MonolithRecipeProcedure;
import mc.sayda.creraces.procedures.ThrowableBarrelRecipeProcedure;
import mc.sayda.creraces.world.inventory.DwarfBlueprintGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DwarfBlueprintGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public DwarfBlueprintGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public DwarfBlueprintGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(DwarfBlueprintGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(DwarfBlueprintGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            DwarfBlueprintGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = DwarfBlueprintGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 1) {
            MonolithRecipeProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            CloseConfigProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            LandmineRecipeProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ThrowableBarrelRecipeProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(DwarfBlueprintGUIButtonMessage.class, DwarfBlueprintGUIButtonMessage::buffer, DwarfBlueprintGUIButtonMessage::new, DwarfBlueprintGUIButtonMessage::handler);
    }
}

