/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.function.Supplier;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.CloseConfigProcedure;
import mc.sayda.creraces.procedures.ConfigServerMenuAllowA1Procedure;
import mc.sayda.creraces.procedures.ConfigServerMenuAllowA2Procedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfigMenuButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ServerConfigMenuButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ServerConfigMenuButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ServerConfigMenuButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ServerConfigMenuButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ServerConfigMenuButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CloseConfigProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            ConfigServerMenuAllowA1Procedure.execute((LevelAccessor)world);
        }
        if (buttonID == 2) {
            ConfigServerMenuAllowA2Procedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(ServerConfigMenuButtonMessage.class, ServerConfigMenuButtonMessage::buffer, ServerConfigMenuButtonMessage::new, ServerConfigMenuButtonMessage::handler);
    }
}

