/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import mc.sayda.creraces.init.CreracesModScreens;
import mc.sayda.creraces.network.RatDenMenuButtonMessage;
import mc.sayda.creraces.world.inventory.RatDenMenuMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class RatDenMenuScreen
extends AbstractContainerScreen<RatDenMenuMenu>
implements CreracesModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox label;
    Button button_remove_den;
    Button button_primary;
    Button button_secondary_hole;
    Button button_empty;
    Button button_empty1;
    Button button_empty2;
    Button button_empty3;
    Button button_empty4;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"creraces:textures/screens/rat_den_menu.png");

    public RatDenMenuScreen(RatDenMenuMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 154;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("label")) {
                this.label.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.label.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.label.isFocused()) {
            return this.label.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String labelValue = this.label.getValue();
        super.resize(minecraft, width, height);
        this.label.setValue(labelValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.creraces.rat_den_menu.label_rat_den_center"), 5, 5, -12829636, false);
    }

    public void init() {
        super.init();
        this.label = new EditBox(this.font, this.leftPos + 7, this.topPos + 20, 160, 18, (Component)Component.translatable((String)"gui.creraces.rat_den_menu.label"));
        this.label.setMaxLength(8192);
        this.label.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((RatDenMenuMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "label", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.label);
        this.button_remove_den = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_remove_den"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new RatDenMenuButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            RatDenMenuButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 6, this.topPos + 127, 81, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_remove_den);
        this.button_primary = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_primary"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new RatDenMenuButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            RatDenMenuButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + 6, this.topPos + 46, 99, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_primary);
        this.button_secondary_hole = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_secondary_hole"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new RatDenMenuButtonMessage(2, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            RatDenMenuButtonMessage.handleButtonAction(this.entity, 2, x, y, this.z);
        }).bounds(this.leftPos + 6, this.topPos + 73, 99, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_secondary_hole);
        this.button_empty = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_empty"), e -> {}).bounds(this.leftPos + 114, this.topPos + 46, 54, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_empty);
        this.button_empty1 = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_empty1"), e -> {}).bounds(this.leftPos + 114, this.topPos + 73, 54, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_empty1);
        this.button_empty2 = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_empty2"), e -> {}).bounds(this.leftPos + 6, this.topPos + 100, 99, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_empty2);
        this.button_empty3 = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_empty3"), e -> {}).bounds(this.leftPos + 114, this.topPos + 100, 54, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_empty3);
        this.button_empty4 = Button.builder((Component)Component.translatable((String)"gui.creraces.rat_den_menu.button_empty4"), e -> {}).bounds(this.leftPos + 96, this.topPos + 127, 72, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_empty4);
    }
}

