/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modeltitan2<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creraces", (String)"modeltitan_2"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart right_leg;
    public final ModelPart left_leg;

    public Modeltitan2(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, -9.0f, -5.0f, 28.0f, 28.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(40, 38).addBox(-4.0f, -14.0f, -6.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -7.0f, -8.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(20, 38).addBox(-18.0f, -1.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 38).addBox(14.0f, -1.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(40, 56).addBox(-4.5f, 0.0f, -2.5f, 6.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)11.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(62, 56).addBox(-2.5f, 0.0f, -2.5f, 6.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

