/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.fluid;

import mc.sayda.creraces.init.CreracesModBlocks;
import mc.sayda.creraces.init.CreracesModFluidTypes;
import mc.sayda.creraces.init.CreracesModFluids;
import mc.sayda.creraces.init.CreracesModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class BlessedWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)CreracesModFluidTypes.BLESSED_WATER_TYPE.get(), () -> (Fluid)CreracesModFluids.BLESSED_WATER.get(), () -> (Fluid)CreracesModFluids.FLOWING_BLESSED_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)CreracesModItems.BLESSED_WATER_BUCKET.get()).block(() -> (LiquidBlock)CreracesModBlocks.BLESSED_WATER.get());

    private BlessedWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.FALLING_WATER;
    }

    public static class Flowing
    extends BlessedWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends BlessedWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

