/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.AncientShardBuyProcedure;
import mc.sayda.creraces.procedures.CursedTomeOpenGUIProcedure;
import mc.sayda.creraces.procedures.PlasmaWandOpenGUIProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record AncientShardShopGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AncientShardShopGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"creraces", (String)"ancient_shard_shop_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AncientShardShopGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new AncientShardShopGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<AncientShardShopGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(AncientShardShopGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> AncientShardShopGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CursedTomeOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            PlasmaWandOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            AncientShardBuyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(TYPE, STREAM_CODEC, AncientShardShopGUIButtonMessage::handleData);
    }
}

