/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.function.Supplier;
import mc.sayda.creraces.CreracesMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CreracesModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"creraces");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        CreracesMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"creraces", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"creraces", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean guideGiven = false;
        public double Grit = 0.0;
        public double Mana = 0.0;
        public double numNumpad = 0.0;
        public double TempValue1 = 0.0;
        public double TempValue2 = 0.0;
        public double TempValue3 = 0.0;
        public double TempValue4 = 0.0;
        public double PassiveCooldown = 0.0;
        public double RaceAbilityToggle = 0.0;
        public double Rage = 0.0;
        public double UltimateCooldown = 0.0;
        public double UltimateCooldown2 = 0.0;
        public double Energy = 200.0;
        public boolean ButtonPos = false;
        public boolean HasChoosenRace = false;
        public boolean HasChoosenSubRace = false;
        public boolean HasPocket = false;
        public boolean HumanCheck = false;
        public boolean RaceUpdate = false;
        public boolean ShowRaceOverlay = true;
        public boolean UseHints = true;
        public double ItemStacks = 0.0;
        public double Karma = 0.0;
        public double RaceAbilityKeep = 0.0;
        public double AD = 0.0;
        public double AH = 0.0;
        public double AP = 0.0;
        public double Coins = 0.0;
        public double CR = 0.0;
        public double dx = 0.0;
        public double dy = 0.0;
        public double dz = 0.0;
        public double Faction = 0.0;
        public double IsRace = 0.0;
        public double PassiveStacks = 0.0;
        public double px = 0.0;
        public double py = 0.0;
        public double pz = 0.0;
        public double RaceRanking = 0.0;
        public double ResourceBar = 0.0;
        public double SkillPoints = 0.0;
        public double SkillSelect = 0.0;
        public double PocketSize = 1.0;
        public double Size = 1.0;
        public double Soul = 9.0;
        public String RaceString = "None";
        public String raceTeam = "None";
        public String raceStyle = "none";
        public double raceStyleState = 0.0;
        public double raceStyleState2 = 0.0;
        public double gState = 0.0;
        public double progressionState = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("guideGiven", this.guideGiven);
            nbt.putDouble("Grit", this.Grit);
            nbt.putDouble("Mana", this.Mana);
            nbt.putDouble("numNumpad", this.numNumpad);
            nbt.putDouble("TempValue1", this.TempValue1);
            nbt.putDouble("TempValue2", this.TempValue2);
            nbt.putDouble("TempValue3", this.TempValue3);
            nbt.putDouble("TempValue4", this.TempValue4);
            nbt.putDouble("PassiveCooldown", this.PassiveCooldown);
            nbt.putDouble("RaceAbilityToggle", this.RaceAbilityToggle);
            nbt.putDouble("Rage", this.Rage);
            nbt.putDouble("UltimateCooldown", this.UltimateCooldown);
            nbt.putDouble("UltimateCooldown2", this.UltimateCooldown2);
            nbt.putDouble("Energy", this.Energy);
            nbt.putBoolean("ButtonPos", this.ButtonPos);
            nbt.putBoolean("HasChoosenRace", this.HasChoosenRace);
            nbt.putBoolean("HasChoosenSubRace", this.HasChoosenSubRace);
            nbt.putBoolean("HasPocket", this.HasPocket);
            nbt.putBoolean("HumanCheck", this.HumanCheck);
            nbt.putBoolean("RaceUpdate", this.RaceUpdate);
            nbt.putBoolean("ShowRaceOverlay", this.ShowRaceOverlay);
            nbt.putBoolean("UseHints", this.UseHints);
            nbt.putDouble("ItemStacks", this.ItemStacks);
            nbt.putDouble("Karma", this.Karma);
            nbt.putDouble("RaceAbilityKeep", this.RaceAbilityKeep);
            nbt.putDouble("AD", this.AD);
            nbt.putDouble("AH", this.AH);
            nbt.putDouble("AP", this.AP);
            nbt.putDouble("Coins", this.Coins);
            nbt.putDouble("CR", this.CR);
            nbt.putDouble("dx", this.dx);
            nbt.putDouble("dy", this.dy);
            nbt.putDouble("dz", this.dz);
            nbt.putDouble("Faction", this.Faction);
            nbt.putDouble("IsRace", this.IsRace);
            nbt.putDouble("PassiveStacks", this.PassiveStacks);
            nbt.putDouble("px", this.px);
            nbt.putDouble("py", this.py);
            nbt.putDouble("pz", this.pz);
            nbt.putDouble("RaceRanking", this.RaceRanking);
            nbt.putDouble("ResourceBar", this.ResourceBar);
            nbt.putDouble("SkillPoints", this.SkillPoints);
            nbt.putDouble("SkillSelect", this.SkillSelect);
            nbt.putDouble("PocketSize", this.PocketSize);
            nbt.putDouble("Size", this.Size);
            nbt.putDouble("Soul", this.Soul);
            nbt.putString("RaceString", this.RaceString);
            nbt.putString("raceTeam", this.raceTeam);
            nbt.putString("raceStyle", this.raceStyle);
            nbt.putDouble("raceStyleState", this.raceStyleState);
            nbt.putDouble("raceStyleState2", this.raceStyleState2);
            nbt.putDouble("gState", this.gState);
            nbt.putDouble("progressionState", this.progressionState);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.guideGiven = nbt.getBoolean("guideGiven");
            this.Grit = nbt.getDouble("Grit");
            this.Mana = nbt.getDouble("Mana");
            this.numNumpad = nbt.getDouble("numNumpad");
            this.TempValue1 = nbt.getDouble("TempValue1");
            this.TempValue2 = nbt.getDouble("TempValue2");
            this.TempValue3 = nbt.getDouble("TempValue3");
            this.TempValue4 = nbt.getDouble("TempValue4");
            this.PassiveCooldown = nbt.getDouble("PassiveCooldown");
            this.RaceAbilityToggle = nbt.getDouble("RaceAbilityToggle");
            this.Rage = nbt.getDouble("Rage");
            this.UltimateCooldown = nbt.getDouble("UltimateCooldown");
            this.UltimateCooldown2 = nbt.getDouble("UltimateCooldown2");
            this.Energy = nbt.getDouble("Energy");
            this.ButtonPos = nbt.getBoolean("ButtonPos");
            this.HasChoosenRace = nbt.getBoolean("HasChoosenRace");
            this.HasChoosenSubRace = nbt.getBoolean("HasChoosenSubRace");
            this.HasPocket = nbt.getBoolean("HasPocket");
            this.HumanCheck = nbt.getBoolean("HumanCheck");
            this.RaceUpdate = nbt.getBoolean("RaceUpdate");
            this.ShowRaceOverlay = nbt.getBoolean("ShowRaceOverlay");
            this.UseHints = nbt.getBoolean("UseHints");
            this.ItemStacks = nbt.getDouble("ItemStacks");
            this.Karma = nbt.getDouble("Karma");
            this.RaceAbilityKeep = nbt.getDouble("RaceAbilityKeep");
            this.AD = nbt.getDouble("AD");
            this.AH = nbt.getDouble("AH");
            this.AP = nbt.getDouble("AP");
            this.Coins = nbt.getDouble("Coins");
            this.CR = nbt.getDouble("CR");
            this.dx = nbt.getDouble("dx");
            this.dy = nbt.getDouble("dy");
            this.dz = nbt.getDouble("dz");
            this.Faction = nbt.getDouble("Faction");
            this.IsRace = nbt.getDouble("IsRace");
            this.PassiveStacks = nbt.getDouble("PassiveStacks");
            this.px = nbt.getDouble("px");
            this.py = nbt.getDouble("py");
            this.pz = nbt.getDouble("pz");
            this.RaceRanking = nbt.getDouble("RaceRanking");
            this.ResourceBar = nbt.getDouble("ResourceBar");
            this.SkillPoints = nbt.getDouble("SkillPoints");
            this.SkillSelect = nbt.getDouble("SkillSelect");
            this.PocketSize = nbt.getDouble("PocketSize");
            this.Size = nbt.getDouble("Size");
            this.Soul = nbt.getDouble("Soul");
            this.RaceString = nbt.getString("RaceString");
            this.raceTeam = nbt.getString("raceTeam");
            this.raceStyle = nbt.getString("raceStyle");
            this.raceStyleState = nbt.getDouble("raceStyleState");
            this.raceStyleState2 = nbt.getDouble("raceStyleState2");
            this.gState = nbt.getDouble("gState");
            this.progressionState = nbt.getDouble("progressionState");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "creraces_mapvars";
        public boolean AllowA1 = true;
        public boolean AllowA2 = true;
        public double ratdenX = 0.0;
        public double ratdenY = 0.0;
        public double ratdenZ = 0.0;
        public double WorldState = 0.0;
        public double TotalGates = 0.0;
        public double TotalPockets = 1.0;
        public String RatKing = "None";
        public double runicCode = 0.0;
        public String loader = "none";
        public boolean bypass = false;
        public boolean kitsuneArenaActive = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.AllowA1 = nbt.getBoolean("AllowA1");
            this.AllowA2 = nbt.getBoolean("AllowA2");
            this.ratdenX = nbt.getDouble("ratdenX");
            this.ratdenY = nbt.getDouble("ratdenY");
            this.ratdenZ = nbt.getDouble("ratdenZ");
            this.WorldState = nbt.getDouble("WorldState");
            this.TotalGates = nbt.getDouble("TotalGates");
            this.TotalPockets = nbt.getDouble("TotalPockets");
            this.RatKing = nbt.getString("RatKing");
            this.runicCode = nbt.getDouble("runicCode");
            this.loader = nbt.getString("loader");
            this.bypass = nbt.getBoolean("bypass");
            this.kitsuneArenaActive = nbt.getBoolean("kitsuneArenaActive");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("AllowA1", this.AllowA1);
            nbt.putBoolean("AllowA2", this.AllowA2);
            nbt.putDouble("ratdenX", this.ratdenX);
            nbt.putDouble("ratdenY", this.ratdenY);
            nbt.putDouble("ratdenZ", this.ratdenZ);
            nbt.putDouble("WorldState", this.WorldState);
            nbt.putDouble("TotalGates", this.TotalGates);
            nbt.putDouble("TotalPockets", this.TotalPockets);
            nbt.putString("RatKing", this.RatKing);
            nbt.putDouble("runicCode", this.runicCode);
            nbt.putString("loader", this.loader);
            nbt.putBoolean("bypass", this.bypass);
            nbt.putBoolean("kitsuneArenaActive", this.kitsuneArenaActive);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "creraces_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.ButtonPos = original.ButtonPos;
            clone.HasChoosenRace = original.HasChoosenRace;
            clone.HasChoosenSubRace = original.HasChoosenSubRace;
            clone.HasPocket = original.HasPocket;
            clone.HumanCheck = original.HumanCheck;
            clone.RaceUpdate = original.RaceUpdate;
            clone.ShowRaceOverlay = original.ShowRaceOverlay;
            clone.UseHints = original.UseHints;
            clone.ItemStacks = original.ItemStacks;
            clone.Karma = original.Karma;
            clone.RaceAbilityKeep = original.RaceAbilityKeep;
            clone.AD = original.AD;
            clone.AH = original.AH;
            clone.AP = original.AP;
            clone.Coins = original.Coins;
            clone.CR = original.CR;
            clone.dx = original.dx;
            clone.dy = original.dy;
            clone.dz = original.dz;
            clone.Faction = original.Faction;
            clone.IsRace = original.IsRace;
            clone.PassiveStacks = original.PassiveStacks;
            clone.px = original.px;
            clone.py = original.py;
            clone.pz = original.pz;
            clone.RaceRanking = original.RaceRanking;
            clone.ResourceBar = original.ResourceBar;
            clone.SkillPoints = original.SkillPoints;
            clone.SkillSelect = original.SkillSelect;
            clone.PocketSize = original.PocketSize;
            clone.Size = original.Size;
            clone.Soul = original.Soul;
            clone.RaceString = original.RaceString;
            clone.raceTeam = original.raceTeam;
            clone.raceStyle = original.raceStyle;
            clone.raceStyleState = original.raceStyleState;
            clone.raceStyleState2 = original.raceStyleState2;
            clone.gState = original.gState;
            clone.progressionState = original.progressionState;
            if (!event.isWasDeath()) {
                clone.guideGiven = original.guideGiven;
                clone.Grit = original.Grit;
                clone.Mana = original.Mana;
                clone.numNumpad = original.numNumpad;
                clone.TempValue1 = original.TempValue1;
                clone.TempValue2 = original.TempValue2;
                clone.TempValue3 = original.TempValue3;
                clone.TempValue4 = original.TempValue4;
                clone.PassiveCooldown = original.PassiveCooldown;
                clone.RaceAbilityToggle = original.RaceAbilityToggle;
                clone.Rage = original.Rage;
                clone.UltimateCooldown = original.UltimateCooldown;
                clone.UltimateCooldown2 = original.UltimateCooldown2;
                clone.Energy = original.Energy;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

