/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.KitsuneEarsStateToggleProcedure;
import mc.sayda.creraces.procedures.KitsuneTailsStateToggleProcedure;
import mc.sayda.creraces.procedures.MirrorSelect0Procedure;
import mc.sayda.creraces.procedures.MirrorSelect1Procedure;
import mc.sayda.creraces.procedures.MirrorSelect2Procedure;
import mc.sayda.creraces.procedures.MirrorSelect3Procedure;
import mc.sayda.creraces.procedures.MirrorSelect4Procedure;
import mc.sayda.creraces.procedures.MirrorSelect5Procedure;
import mc.sayda.creraces.procedures.MirrorSelect6Procedure;
import mc.sayda.creraces.procedures.MirrorSelectProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MirrorGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MirrorGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"creraces", (String)"mirror_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MirrorGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MirrorGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MirrorGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MirrorGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MirrorGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MirrorSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            MirrorSelect1Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            MirrorSelect2Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            MirrorSelect3Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            MirrorSelect4Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            MirrorSelect5Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            MirrorSelect6Procedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            MirrorSelect0Procedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            KitsuneTailsStateToggleProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            KitsuneEarsStateToggleProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(TYPE, STREAM_CODEC, MirrorGUIButtonMessage::handleData);
    }
}

