/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.veggiesdelight.block.custom;

import net.mehdinoui.veggiesdelight.item.ModFoods;
import net.mehdinoui.veggiesdelight.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class CarrotCakeBlock
extends CakeBlock {
    public CarrotCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ModTags.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.customEat(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.customEat(level, pos, state, player);
    }

    private InteractionResult customEat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(ModFoods.CARROT_CAKE_SLICE);
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < 6) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    private ItemInteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < 6) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        Direction direction = Direction.WEST;
        double x = (double)pos.getX() + 0.5 + (double)direction.getStepX() * 0.05;
        double y = (double)pos.getY() + 0.3;
        double z = (double)pos.getZ() + 0.5 + (double)direction.getStepZ() * 0.05;
        double velocityX = (double)direction.getStepX() * 0.05;
        double velocityZ = (double)direction.getStepZ() * 0.05;
        double velocityY = 0.02;
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ModItems.CARROT_CAKE_SLICE.get()), (double)x, (double)y, (double)z, (double)velocityX, (double)velocityY, (double)velocityZ);
        level.playSound((Player)null, pos, SoundEvents.WOOL_BREAK, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }
}

