/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.veggiesdelight.block.custom.crops;

import net.mehdinoui.veggiesdelight.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ZucchiniCropBlock
extends CropBlock {
    public static final int MAX_AGE = 7;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;

    public ZucchiniCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.ZUCCHINI_SEEDS.get();
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        int currentAge = (Integer)state.getValue((Property)AGE);
        if (currentAge == 7) {
            int quantity = 1 + level.random.nextInt(2);
            ZucchiniCropBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.ZUCCHINI.get(), quantity));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(currentAge - 3)));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }
}

