/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.veggiesdelight.datagen;

import java.util.concurrent.CompletableFuture;
import net.mehdinoui.veggiesdelight.datagen.BlockTags;
import net.mehdinoui.veggiesdelight.datagen.ItemTags;
import net.mehdinoui.veggiesdelight.datagen.ModCompostablesDataMap;
import net.mehdinoui.veggiesdelight.datagen.ModItemModelProvider;
import net.mehdinoui.veggiesdelight.datagen.recipe.ModBasicRecipes;
import net.mehdinoui.veggiesdelight.datagen.recipe.ModCookingRecipes;
import net.mehdinoui.veggiesdelight.datagen.recipe.ModCuttingRecipes;
import net.mehdinoui.veggiesdelight.datagen.recipe.ModSmeltingRecipes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="veggiesdelight")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTags blockTags = new BlockTags(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTags(packOutput, lookupProvider, blockTags.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModCompostablesDataMap(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(packOutput, lookupProvider){

            protected void buildRecipes(@NotNull RecipeOutput output) {
                ModBasicRecipes.register(output);
                ModCookingRecipes.register(output);
                ModCuttingRecipes.register(output);
                ModSmeltingRecipes.register(output);
            }
        });
    }
}

